/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import javax.annotation.Nullable;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.PatternCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.WheelchairCostCalculator;

public class CostCalculatorFactory {
    public static <T extends DefaultTripSchedule> RaptorCostCalculator<T> createCostCalculator(GeneralizedCostParameters generalizedCostParameters, @Nullable int[] stopBoardAlightTransferCosts) {
        Object calculator = new DefaultCostCalculator(generalizedCostParameters, stopBoardAlightTransferCosts);
        if (generalizedCostParameters.wheelchairEnabled()) {
            calculator = new WheelchairCostCalculator(calculator, generalizedCostParameters.wheelchairAccessibility());
        }
        if (!generalizedCostParameters.unpreferredPatterns().isEmpty()) {
            calculator = new PatternCostCalculator(calculator, generalizedCostParameters.unpreferredPatterns(), generalizedCostParameters.unnpreferredCost());
        }
        return calculator;
    }
}

