/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import java.util.List;
import java.util.Objects;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class ConstrainedTransfersForPatterns {
    private final List<TransferForPatternByStopPos> transfersToStop;
    private final List<TransferForPatternByStopPos> transfersFromStop;

    public ConstrainedTransfersForPatterns(List<TransferForPatternByStopPos> transfersToStop, List<TransferForPatternByStopPos> transfersFromStop) {
        this.transfersToStop = transfersToStop;
        this.transfersFromStop = transfersFromStop;
    }

    public TransferForPatternByStopPos toStop(int routeIndex) {
        return this.transfersToStop.get(routeIndex);
    }

    public TransferForPatternByStopPos fromStop(int routeIndex) {
        return this.transfersFromStop.get(routeIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstrainedTransfersForPatterns that = (ConstrainedTransfersForPatterns)o;
        return Objects.equals(this.transfersToStop, that.transfersToStop) && Objects.equals(this.transfersFromStop, that.transfersFromStop);
    }

    public int hashCode() {
        return Objects.hash(this.transfersToStop, this.transfersFromStop);
    }

    public String toString() {
        return ToStringBuilder.of(ConstrainedTransfersForPatterns.class).addCol("to", this.transfersToStop).addCol("from", this.transfersFromStop).toString();
    }
}

