/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import java.util.function.Consumer;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;

public class ConstrainedTransferBoarding<T extends RaptorTripSchedule>
implements RaptorBoardOrAlightEvent<T> {
    private final RaptorTransferConstraint constraint;
    private final int tripIndex;
    private final T trip;
    private final int stopPositionInPattern;
    private final int time;
    private final int earliestBoardTime;

    public ConstrainedTransferBoarding(RaptorTransferConstraint constraint, int tripIndex, T trip, int stopPositionInPattern, int time, int earliestBoardTime) {
        this.constraint = constraint;
        this.tripIndex = tripIndex;
        this.trip = trip;
        this.stopPositionInPattern = stopPositionInPattern;
        this.time = time;
        this.earliestBoardTime = earliestBoardTime;
    }

    public int tripIndex() {
        return this.tripIndex;
    }

    public T trip() {
        return this.trip;
    }

    public int stopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    public int time() {
        return this.time;
    }

    public int earliestBoardTime() {
        return this.earliestBoardTime;
    }

    public RaptorTransferConstraint transferConstraint() {
        return this.constraint;
    }

    public boolean empty() {
        return false;
    }

    public void boardWithFallback(Consumer<RaptorBoardOrAlightEvent<T>> boardCallback, Consumer<RaptorBoardOrAlightEvent<T>> alternativeBoardingFallback) {
        if (this.empty()) {
            alternativeBoardingFallback.accept(this);
        } else if (!this.constraint.isNotAllowed()) {
            boardCallback.accept(this);
        }
    }
}

