/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.Duration;
import java.util.List;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.site.StopTransferPriority;
import org.opentripplanner.utils.time.DurationUtils;

public interface TransitTuningParameters {
    public static final List<Duration> PAGING_SEARCH_WINDOW_ADJUSTMENTS = DurationUtils.durations((String)"4h 2h 1h 30m 20m 10m");
    public static final TransitTuningParameters FOR_TEST = new TransitTuningParameters(){

        @Override
        public boolean enableStopTransferPriority() {
            return true;
        }

        @Override
        public Integer stopBoardAlightDuringTransferCost(StopTransferPriority key) {
            switch (key) {
                case DISCOURAGED: {
                    return 3600;
                }
                case ALLOWED: {
                    return 60;
                }
                case RECOMMENDED: {
                    return 20;
                }
                case PREFERRED: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Unknown key: " + String.valueOf((Object)key));
        }

        @Override
        public int transferCacheMaxSize() {
            return 5;
        }

        @Override
        public Duration maxSearchWindow() {
            return Duration.ofHours(24L);
        }

        @Override
        public List<Duration> pagingSearchWindowAdjustments() {
            return PAGING_SEARCH_WINDOW_ADJUSTMENTS;
        }

        @Override
        public List<RouteRequest> transferCacheRequests() {
            return List.of();
        }
    };

    public boolean enableStopTransferPriority();

    public Integer stopBoardAlightDuringTransferCost(StopTransferPriority var1);

    public int transferCacheMaxSize();

    public Duration maxSearchWindow();

    public List<Duration> pagingSearchWindowAdjustments();

    public List<RouteRequest> transferCacheRequests();
}

