/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultRaptorTransfer;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.EdgeTraverser;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.utils.logging.Throttle;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transfer {
    private static final Logger LOG = LoggerFactory.getLogger(Transfer.class);
    private static final Throttle THROTTLE_COST_EXCEEDED = Throttle.ofOneSecond();
    protected static final int MAX_TRANSFER_COST = 2000000;
    private final int toStop;
    private final int distanceMeters;
    private final EnumSet<StreetMode> modes;
    private final List<Edge> edges;

    private Transfer(int toStop, int distanceMeters, EnumSet<StreetMode> modes, List<Edge> edges) {
        this.toStop = toStop;
        this.distanceMeters = distanceMeters;
        this.modes = EnumSet.copyOf(modes);
        this.edges = edges;
    }

    public Transfer(int toStop, List<Edge> edges, EnumSet<StreetMode> modes) {
        this(toStop, (int)edges.stream().mapToDouble(Edge::getDistanceMeters).sum(), modes, edges);
    }

    public Transfer(int toStopIndex, int distanceMeters, EnumSet<StreetMode> modes) {
        this(toStopIndex, distanceMeters, modes, null);
    }

    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (this.edges == null) {
            return coordinates;
        }
        for (Edge edge : this.edges) {
            if (edge.getGeometry() == null) continue;
            coordinates.addAll(Arrays.asList(edge.getGeometry().getCoordinates()));
        }
        return coordinates;
    }

    public int getToStop() {
        return this.toStop;
    }

    public int getDistanceMeters() {
        return this.distanceMeters;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public boolean allowsMode(StreetMode mode) {
        return this.modes.contains(mode);
    }

    public Optional<RaptorTransfer> asRaptorTransfer(StreetSearchRequest request) {
        WalkPreferences walkPreferences = request.preferences().walk();
        if (this.edges == null || this.edges.isEmpty()) {
            double durationSeconds = (double)this.distanceMeters / walkPreferences.speed();
            double domainCost = this.costLimitSanityCheck(durationSeconds * walkPreferences.reluctance());
            return Optional.of(new DefaultRaptorTransfer(this.toStop, (int)Math.ceil(durationSeconds), RaptorCostConverter.toRaptorCost((double)domainCost), this));
        }
        StateEditor se = new StateEditor(this.edges.get(0).getFromVertex(), request);
        se.setTimeSeconds(0L);
        Optional<State> state = EdgeTraverser.traverseEdges(se.makeState(), this.edges);
        return state.map(s -> new DefaultRaptorTransfer(this.toStop, (int)s.getElapsedTimeSeconds(), RaptorCostConverter.toRaptorCost((int)this.costLimitSanityCheck(s.getWeight())), this));
    }

    public String modesAsString() {
        return this.modes.size() == 1 ? ((StreetMode)this.modes.stream().findFirst().get()).toString() : this.modes.toString();
    }

    private int costLimitSanityCheck(double cost) {
        if (cost >= 0.0 && cost <= 2000000.0) {
            return (int)cost;
        }
        THROTTLE_COST_EXCEEDED.throttle(() -> LOG.warn("Transfer exceeded maximum cost. Please consider changing the transfer cost calculation. More information: https://github.com/opentripplanner/OpenTripPlanner/pull/5516#issuecomment-1819138078"));
        return 2000000;
    }

    public String toString() {
        return ToStringBuilder.of(Transfer.class).addNum("toStop", (Number)this.toStop).addNum("distance", (Number)this.distanceMeters, "m").toString();
    }
}

