/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import org.opentripplanner.raptor.spi.RaptorSlackProvider;
import org.opentripplanner.routing.api.request.framework.DurationForEnum;
import org.opentripplanner.transit.model.basic.TransitMode;

public final class SlackProvider
implements RaptorSlackProvider {
    private final int[] boardSlack;
    private final int[] alightSlack;
    private final int transferSlack;

    public SlackProvider(int transferSlack, DurationForEnum<TransitMode> boardSlack, DurationForEnum<TransitMode> alightSlack) {
        this.transferSlack = transferSlack;
        this.boardSlack = SlackProvider.slackByMode(boardSlack);
        this.alightSlack = SlackProvider.slackByMode(alightSlack);
    }

    public int transferSlack() {
        return this.transferSlack;
    }

    public int boardSlack(int slackIndex) {
        return this.boardSlack[slackIndex];
    }

    public int alightSlack(int slackIndex) {
        return this.alightSlack[slackIndex];
    }

    private static int[] slackByMode(DurationForEnum<TransitMode> slack) {
        int[] result = new int[TransitMode.values().length];
        for (TransitMode mode : TransitMode.values()) {
            result[SlackProvider.slackIndex((TransitMode)mode)] = (int)slack.valueOf(mode).toSeconds();
        }
        return result;
    }

    public static int slackIndex(TransitMode mode) {
        return mode.ordinal();
    }
}

