/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransfersForPatterns;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRequestTransferCache;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.SiteRepository;

public class RaptorTransitData {
    private final HashMap<LocalDate, List<TripPatternForDate>> tripPatternsRunningOnDate;
    private final List<List<Transfer>> transfersByStopIndex;
    private final TransferService transferService;
    private final SiteRepository siteRepository;
    private final RaptorRequestTransferCache transferCache;
    private ConstrainedTransfersForPatterns constrainedTransfers;
    private final TransferIndexGenerator transferIndexGenerator;
    @Nullable
    private final int[] stopBoardAlightTransferCosts;

    public RaptorTransitData(RaptorTransitData raptorTransitData) {
        this(raptorTransitData.tripPatternsRunningOnDate, raptorTransitData.transfersByStopIndex, raptorTransitData.transferService, raptorTransitData.siteRepository, raptorTransitData.transferCache, raptorTransitData.constrainedTransfers, raptorTransitData.transferIndexGenerator, raptorTransitData.stopBoardAlightTransferCosts);
    }

    public RaptorTransitData(Map<LocalDate, List<TripPatternForDate>> tripPatternsRunningOnDate, List<List<Transfer>> transfersByStopIndex, TransferService transferService, SiteRepository siteRepository, RaptorRequestTransferCache transferCache, ConstrainedTransfersForPatterns constrainedTransfers, TransferIndexGenerator transferIndexGenerator, @Nullable int[] stopBoardAlightTransferCosts) {
        this.tripPatternsRunningOnDate = new HashMap<LocalDate, List<TripPatternForDate>>(tripPatternsRunningOnDate);
        this.transfersByStopIndex = transfersByStopIndex;
        this.transferService = transferService;
        this.siteRepository = siteRepository;
        this.transferCache = transferCache;
        this.constrainedTransfers = constrainedTransfers;
        this.transferIndexGenerator = transferIndexGenerator;
        this.stopBoardAlightTransferCosts = stopBoardAlightTransferCosts;
    }

    @Nullable
    public StopLocation getStopByIndex(int stop) {
        return stop == -1 ? null : this.siteRepository.stopByIndex(stop);
    }

    public Collection<TripPatternForDate> getTripPatternsForRunningDate(LocalDate date) {
        return this.tripPatternsRunningOnDate.getOrDefault(date, List.of());
    }

    public int getStopCount() {
        return this.siteRepository.stopIndexSize();
    }

    public List<TripPatternForDate> getTripPatternsRunningOnDateCopy(LocalDate runningPeriodDate) {
        List<TripPatternForDate> tripPatternForDate = this.tripPatternsRunningOnDate.get(runningPeriodDate);
        return tripPatternForDate != null ? new ArrayList<TripPatternForDate>(tripPatternForDate) : new ArrayList();
    }

    public List<TripPatternForDate> getTripPatternsOnServiceDateCopy(LocalDate date) {
        List<TripPatternForDate> tripPatternsRunningOnDates = this.getTripPatternsRunningOnDateCopy(date);
        tripPatternsRunningOnDates.addAll(this.getTripPatternsRunningOnDateCopy(date.plusDays(1L)));
        return tripPatternsRunningOnDates.stream().filter(t -> t.getServiceDate().equals(date)).distinct().collect(Collectors.toList());
    }

    public TransferService getTransferService() {
        return this.transferService;
    }

    public RaptorTransferIndex getRaptorTransfersForRequest(RouteRequest request) {
        return this.transferCache.get(this.transfersByStopIndex, request);
    }

    public void initTransferCacheForRequest(RouteRequest request) {
        this.transferCache.put(this.transfersByStopIndex, request);
    }

    public RaptorRequestTransferCache getTransferCache() {
        return this.transferCache;
    }

    @Nullable
    public ConstrainedTransfersForPatterns getConstrainedTransfers() {
        return this.constrainedTransfers;
    }

    public TransferIndexGenerator getTransferIndexGenerator() {
        return this.transferIndexGenerator;
    }

    @Nullable
    public int[] getStopBoardAlightTransferCosts() {
        return this.stopBoardAlightTransferCosts;
    }

    public void replaceTripPatternsForDate(LocalDate date, List<TripPatternForDate> tripPatternForDates) {
        this.tripPatternsRunningOnDate.replace(date, tripPatternForDates);
    }

    public void setConstrainedTransfers(ConstrainedTransfersForPatterns constrainedTransfers) {
        this.constrainedTransfers = constrainedTransfers;
    }
}

