/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultRaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;

public class RaptorTransferIndex {
    private final List<RaptorTransfer>[] forwardTransfers;
    private final List<RaptorTransfer>[] reversedTransfers;

    public RaptorTransferIndex(List<List<RaptorTransfer>> forwardTransfers, List<List<RaptorTransfer>> reversedTransfers) {
        this.forwardTransfers = (List[])forwardTransfers.stream().map(List::copyOf).toArray(List[]::new);
        this.reversedTransfers = (List[])reversedTransfers.stream().map(List::copyOf).toArray(List[]::new);
    }

    public static RaptorTransferIndex createInitialSetup(List<List<Transfer>> transfersByStopIndex, StreetSearchRequest request) {
        return RaptorTransferIndex.create(transfersByStopIndex, request, RequestSource.SETUP);
    }

    public static RaptorTransferIndex createRequestScope(List<List<Transfer>> transfersByStopIndex, StreetSearchRequest request) {
        return RaptorTransferIndex.create(transfersByStopIndex, request, RequestSource.REQUEST_SCOPE);
    }

    private static RaptorTransferIndex create(List<List<Transfer>> transfersByStopIndex, StreetSearchRequest request, RequestSource requestSource) {
        ArrayList<List<RaptorTransfer>> forwardTransfers = new ArrayList<List<RaptorTransfer>>(transfersByStopIndex.size());
        ArrayList<List<RaptorTransfer>> reversedTransfers = new ArrayList<List<RaptorTransfer>>(transfersByStopIndex.size());
        StreetMode mode = request.mode();
        for (int i = 0; i < transfersByStopIndex.size(); ++i) {
            forwardTransfers.add(new ArrayList());
            reversedTransfers.add(new ArrayList());
        }
        IntStream stopIndices = IntStream.range(0, transfersByStopIndex.size());
        if (requestSource == RequestSource.SETUP || OTPFeature.ParallelRouting.isOn()) {
            stopIndices = stopIndices.parallel();
        }
        stopIndices.forEach(fromStop -> {
            Collection transfers = ((List)transfersByStopIndex.get(fromStop)).stream().filter(transfer -> transfer.allowsMode(mode)).flatMap(s -> s.asRaptorTransfer(request).stream()).collect(Collectors.toMap(RaptorTransfer::stop, Function.identity(), (a, b) -> a.c1() < b.c1() ? a : b)).values();
            ((List)forwardTransfers.get(fromStop)).addAll(transfers);
        });
        for (int fromStop2 = 0; fromStop2 < transfersByStopIndex.size(); ++fromStop2) {
            for (RaptorTransfer forwardTransfer : (List)forwardTransfers.get(fromStop2)) {
                reversedTransfers.get(forwardTransfer.stop()).add(((DefaultRaptorTransfer)forwardTransfer).reverseOf(fromStop2));
            }
        }
        return new RaptorTransferIndex(forwardTransfers, reversedTransfers);
    }

    public List<RaptorTransfer> getForwardTransfers(int stopIndex) {
        return this.forwardTransfers[stopIndex];
    }

    public List<RaptorTransfer> getReversedTransfers(int stopIndex) {
        return this.reversedTransfers[stopIndex];
    }

    private static enum RequestSource {
        SETUP,
        REQUEST_SCOPE;

    }
}

