/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressType;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;

public class FlexAccessEgressAdapter
extends DefaultAccessEgress {
    private final FlexAccessEgress flexAccessEgress;

    public FlexAccessEgressAdapter(FlexAccessEgress flexAccessEgress, AccessEgressType accessOrEgress) {
        super(flexAccessEgress.stop().getIndex(), accessOrEgress.isEgress() ? flexAccessEgress.lastState().reverse() : flexAccessEgress.lastState());
        this.flexAccessEgress = flexAccessEgress;
    }

    private FlexAccessEgressAdapter(FlexAccessEgressAdapter other, TimeAndCost penalty) {
        super(other, penalty);
        this.flexAccessEgress = other.flexAccessEgress;
    }

    @Override
    public int earliestDepartureTime(int requestedDepartureTime) {
        return FlexAccessEgressAdapter.mapToRaptorTime(this.flexAccessEgress.earliestDepartureTime(requestedDepartureTime));
    }

    @Override
    public int latestArrivalTime(int requestedArrivalTime) {
        return FlexAccessEgressAdapter.mapToRaptorTime(this.flexAccessEgress.latestArrivalTime(requestedArrivalTime));
    }

    public int numberOfRides() {
        return 1;
    }

    public boolean stopReachedOnBoard() {
        return this.flexAccessEgress.stopReachedOnBoard();
    }

    @Override
    public boolean hasOpeningHours() {
        return true;
    }

    @Override
    public boolean isWalkOnly() {
        return false;
    }

    @Override
    public RoutingAccessEgress withPenalty(TimeAndCost penalty) {
        return new FlexAccessEgressAdapter(this, penalty);
    }

    private static int mapToRaptorTime(int flexTime) {
        return flexTime == -999 ? -1999000000 : flexTime;
    }
}

