/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.Objects;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.utils.lang.OtpNumberFormat;
import org.opentripplanner.utils.time.DurationUtils;

public final class DefaultRaptorTransfer
implements RaptorTransfer {
    private final int stop;
    private final int durationInSeconds;
    private final int c1;
    private final Transfer transfer;

    public DefaultRaptorTransfer(int stop, int durationInSeconds, int c1, Transfer transfer) {
        this.stop = stop;
        this.durationInSeconds = durationInSeconds;
        this.c1 = c1;
        this.transfer = transfer;
    }

    public int stop() {
        return this.stop;
    }

    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    public int c1() {
        return this.c1;
    }

    public Transfer transfer() {
        return this.transfer;
    }

    public DefaultRaptorTransfer reverseOf(int fromStopIndex) {
        return new DefaultRaptorTransfer(fromStopIndex, this.durationInSeconds, this.c1, this.transfer);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRaptorTransfer that = (DefaultRaptorTransfer)o;
        return this.stop == that.stop && this.durationInSeconds == that.durationInSeconds && this.c1 == that.c1;
    }

    public int hashCode() {
        return Objects.hash(this.stop, this.durationInSeconds, this.c1);
    }

    public String toString() {
        String duration = DurationUtils.durationToStr((int)this.durationInSeconds());
        return String.format("%s %s %s ~ %d", this.transfer.modesAsString(), duration, OtpNumberFormat.formatCostCenti((int)this.c1), this.stop());
    }
}

