/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.Objects;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;
import org.opentripplanner.street.search.state.State;

public class DefaultAccessEgress
implements RoutingAccessEgress {
    private final int stop;
    private final int durationInSeconds;
    private final int generalizedCost;
    private final int timePenalty;
    private final TimeAndCost penalty;
    private final State lastState;

    public DefaultAccessEgress(int stop, int durationInSeconds, int generalizedCost, TimeAndCost penalty, State lastState) {
        this.stop = stop;
        this.durationInSeconds = durationInSeconds;
        this.generalizedCost = generalizedCost;
        this.timePenalty = penalty.isZero() ? -1999000000 : penalty.timeInSeconds();
        this.penalty = penalty;
        this.lastState = Objects.requireNonNull(lastState);
    }

    public DefaultAccessEgress(int stop, State lastState) {
        this(stop, (int)lastState.getElapsedTimeSeconds(), RaptorCostConverter.toRaptorCost((double)lastState.getWeight()), TimeAndCost.ZERO, lastState);
    }

    protected DefaultAccessEgress(RoutingAccessEgress other, TimeAndCost penalty) {
        this(other.stop(), other.durationInSeconds(), other.c1() + penalty.cost().toCentiSeconds(), penalty, other.getLastState());
        if (other.penalty() != TimeAndCost.ZERO) {
            throw new IllegalStateException("Can not add penalty twice...");
        }
    }

    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    public int timePenalty() {
        return this.timePenalty;
    }

    public int stop() {
        return this.stop;
    }

    public int c1() {
        return this.generalizedCost;
    }

    public boolean hasOpeningHours() {
        return false;
    }

    @Override
    public State getLastState() {
        return this.lastState;
    }

    @Override
    public boolean isWalkOnly() {
        return this.lastState.containsOnlyWalkMode();
    }

    @Override
    public TimeAndCost penalty() {
        return this.penalty;
    }

    @Override
    public RoutingAccessEgress withPenalty(TimeAndCost penalty) {
        return new DefaultAccessEgress(this, penalty);
    }

    public int earliestDepartureTime(int requestedDepartureTime) {
        return requestedDepartureTime;
    }

    public int latestArrivalTime(int requestedArrivalTime) {
        return requestedArrivalTime;
    }

    public String toString() {
        return this.asString(true, true, this.summary());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoutingAccessEgress)) {
            return false;
        }
        RoutingAccessEgress that = (RoutingAccessEgress)o;
        return this.stop() == that.stop() && this.durationInSeconds() == that.durationInSeconds() && this.c1() == that.c1() && this.penalty().equals(that.penalty());
    }

    public int hashCode() {
        return Objects.hash(this.stop, this.durationInSeconds, this.generalizedCost, this.penalty);
    }

    private String summary() {
        return this.penalty.isZero() ? null : "w/penalty" + String.valueOf(this.penalty);
    }
}

