/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.street;

import java.util.Collections;
import java.util.List;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.mapping.ItinerariesHelper;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.error.PathNotFoundException;
import org.opentripplanner.routing.impl.GraphPathFinder;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.street.search.state.State;

public class DirectStreetRouter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Itinerary> route(OtpServerRequestContext serverContext, RouteRequest request) {
        if (request.journey().direct().mode() == StreetMode.NOT_SET) {
            return Collections.emptyList();
        }
        OTPRequestTimeoutException.checkForTimeout();
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(serverContext.graph(), serverContext.vertexLinker(), serverContext.transitService()::findStopOrChildIds, request.from(), request.to(), request.journey().direct().mode(), request.journey().direct().mode());){
            float maxCarSpeed = serverContext.streetLimitationParametersService().getMaxCarSpeed();
            if (!DirectStreetRouter.straightLineDistanceIsWithinLimit(request, temporaryVertices, maxCarSpeed)) {
                List<Itinerary> list = Collections.emptyList();
                return list;
            }
            GraphPathFinder gpFinder = new GraphPathFinder(serverContext.traverseVisitor(), serverContext.dataOverlayContext(request), maxCarSpeed);
            List<GraphPath<State, Edge, Vertex>> paths = gpFinder.graphPathFinderEntryPoint(request, temporaryVertices);
            GraphPathToItineraryMapper graphPathToItineraryMapper = new GraphPathToItineraryMapper(serverContext.transitService().getTimeZone(), serverContext.graph().streetNotesService, serverContext.graph().ellipsoidToGeoidDifference);
            List<Itinerary> response = graphPathToItineraryMapper.mapItineraries(paths);
            List<Itinerary> list = response = ItinerariesHelper.decorateItinerariesWithRequestData(response, request.journey().wheelchair(), request.preferences().wheelchair());
            return list;
        }
        catch (PathNotFoundException e) {
            return Collections.emptyList();
        }
    }

    private static boolean straightLineDistanceIsWithinLimit(RouteRequest request, TemporaryVerticesContainer vertexContainer, float maxCarSpeed) {
        double distance = SphericalDistanceLibrary.distance(vertexContainer.getFromVertices().iterator().next().getCoordinate(), vertexContainer.getToVertices().iterator().next().getCoordinate());
        return distance < DirectStreetRouter.calculateDistanceMaxLimit(request, maxCarSpeed);
    }

    private static double calculateDistanceMaxLimit(RouteRequest request, float maxCarSpeed) {
        double distanceLimit;
        RoutingPreferences preferences = request.preferences();
        StreetMode mode = request.journey().direct().mode();
        double durationLimit = preferences.street().maxDirectDuration().valueOf(mode).toSeconds();
        if (mode.includesDriving()) {
            distanceLimit = durationLimit * (double)maxCarSpeed;
        } else if (mode.includesBiking()) {
            distanceLimit = durationLimit * preferences.bike().speed();
        } else if (mode.includesScooter()) {
            distanceLimit = durationLimit * preferences.scooter().speed();
        } else if (mode.includesWalking()) {
            distanceLimit = durationLimit * preferences.walk().speed();
        } else {
            throw new IllegalStateException("Could not set max limit for StreetMode");
        }
        return distanceLimit;
    }
}

