/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.street;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.graph_builder.module.nearbystops.StreetNearbyStopFinder;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressType;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.utils.collection.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessEgressRouter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessEgressRouter.class);

    private AccessEgressRouter() {
    }

    public static Collection<NearbyStop> findAccessEgresses(RouteRequest request, TemporaryVerticesContainer verticesContainer, StreetRequest streetRequest, @Nullable DataOverlayContext dataOverlayContext, AccessEgressType accessOrEgress, Duration durationLimit, int maxStopCount) {
        OTPRequestTimeoutException.checkForTimeout();
        List<NearbyStop> zeroDistanceAccessEgress = AccessEgressRouter.findAccessEgressWithZeroDistance(verticesContainer, request, streetRequest, accessOrEgress);
        Set<Vertex> ignoreVertices = zeroDistanceAccessEgress.stream().map(nearbyStop -> nearbyStop.state.getVertex()).collect(Collectors.toSet());
        Set<Vertex> originVertices = accessOrEgress.isAccess() ? verticesContainer.getFromVertices() : verticesContainer.getToVertices();
        Collection<NearbyStop> streetAccessEgress = new StreetNearbyStopFinder(durationLimit, maxStopCount, dataOverlayContext, ignoreVertices).findNearbyStops(originVertices, request, streetRequest, accessOrEgress.isEgress());
        List results = ListUtils.combine((Collection[])new Collection[]{zeroDistanceAccessEgress, streetAccessEgress});
        LOG.debug("Found {} {} stops", (Object)results.size(), (Object)accessOrEgress);
        return results;
    }

    private static List<NearbyStop> findAccessEgressWithZeroDistance(TemporaryVerticesContainer verticesContainer, RouteRequest routeRequest, StreetRequest streetRequest, AccessEgressType accessOrEgress) {
        Set<TransitStopVertex> transitStopVertices = accessOrEgress.isAccess() ? verticesContainer.getFromStopVertices() : verticesContainer.getToStopVertices();
        return NearbyStop.nearbyStopsForTransitStopVerticesFiltered(transitStopVertices, accessOrEgress.isEgress(), routeRequest, streetRequest);
    }
}

