/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.street;

import java.util.Collection;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.framework.TimeAndCostPenalty;
import org.opentripplanner.routing.api.request.framework.TimeAndCostPenaltyForEnum;

public class AccessEgressPenaltyDecorator {
    private final StreetMode accessMode;
    private final StreetMode egressMode;
    private final TimeAndCostPenaltyForEnum<StreetMode> penalty;

    public AccessEgressPenaltyDecorator(StreetMode accessMode, StreetMode egressMode, TimeAndCostPenaltyForEnum<StreetMode> penalty) {
        this.accessMode = accessMode;
        this.egressMode = egressMode;
        this.penalty = penalty;
    }

    public Collection<? extends RoutingAccessEgress> decorateAccess(Collection<RoutingAccessEgress> list) {
        return this.decorate(list, this.accessMode);
    }

    public Collection<? extends RoutingAccessEgress> decorateEgress(Collection<RoutingAccessEgress> list) {
        return this.decorate(list, this.egressMode);
    }

    private Collection<? extends RoutingAccessEgress> decorate(Collection<RoutingAccessEgress> input, StreetMode requestedMode) {
        if (input.isEmpty()) {
            return input;
        }
        TimeAndCostPenalty penaltyWalking = this.penalty.valueOf(StreetMode.WALK);
        if (requestedMode == StreetMode.WALK) {
            return penaltyWalking.isEmpty() ? input : input.stream().map(it -> it.withPenalty(penaltyWalking.calculate(it.durationInSeconds()))).toList();
        }
        TimeAndCostPenalty penaltyRequestedMode = this.penalty.valueOf(requestedMode);
        if (penaltyRequestedMode.isEmpty() && penaltyWalking.isEmpty()) {
            return input;
        }
        return input.stream().map(it -> {
            TimeAndCostPenalty penalty = it.isWalkOnly() ? penaltyWalking : penaltyRequestedMode;
            return it.withPenalty(penalty.calculate(it.durationInSeconds()));
        }).toList();
    }
}

