/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.ext.ridehailing.RideHailingAccessShifter;
import org.opentripplanner.ext.sorlandsbanen.SorlandsbanenNorwayService;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.raptor.RaptorService;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.response.RaptorResponse;
import org.opentripplanner.raptor.spi.ExtraMcRouterSearch;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.opentripplanner.routing.algorithm.mapping.RaptorPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AdditionalSearchDays;
import org.opentripplanner.routing.algorithm.raptoradapter.router.TransitRouterResult;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressPenaltyDecorator;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressType;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgresses;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.FlexAccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.AccessEgressMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RaptorRequestMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RouteRequestTransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.transferoptimization.OptimizeTransferService;
import org.opentripplanner.routing.algorithm.transferoptimization.configure.TransferOptimizationServiceConfigurator;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteRequestBuilder;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.AccessEgressPreferences;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.framework.DebugTimingAggregator;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.via.ViaCoordinateTransferFactory;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.transit.model.framework.EntityNotFoundException;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.grouppriority.TransitGroupPriorityService;
import org.opentripplanner.transit.model.site.StopLocation;

public class TransitRouter {
    public static final int NOT_SET = -1;
    private final RouteRequest request;
    private final OtpServerRequestContext serverContext;
    private final TransitGroupPriorityService transitGroupPriorityService;
    private final DebugTimingAggregator debugTimingAggregator;
    private final ZonedDateTime transitSearchTimeZero;
    private final AdditionalSearchDays additionalSearchDays;
    private final TemporaryVerticesContainer temporaryVerticesContainer;
    private final ViaCoordinateTransferFactory viaTransferResolver;

    private TransitRouter(RouteRequest request, OtpServerRequestContext serverContext, TransitGroupPriorityService transitGroupPriorityService, ZonedDateTime transitSearchTimeZero, AdditionalSearchDays additionalSearchDays, DebugTimingAggregator debugTimingAggregator) {
        this.request = request;
        this.serverContext = serverContext;
        this.transitGroupPriorityService = transitGroupPriorityService;
        this.transitSearchTimeZero = transitSearchTimeZero;
        this.additionalSearchDays = additionalSearchDays;
        this.debugTimingAggregator = debugTimingAggregator;
        this.temporaryVerticesContainer = this.createTemporaryVerticesContainer(request, serverContext);
        this.viaTransferResolver = serverContext.viaTransferResolver();
    }

    public static TransitRouterResult route(RouteRequest request, OtpServerRequestContext serverContext, TransitGroupPriorityService priorityGroupConfigurator, ZonedDateTime transitSearchTimeZero, AdditionalSearchDays additionalSearchDays, DebugTimingAggregator debugTimingAggregator) {
        TransitRouter transitRouter = new TransitRouter(request, serverContext, priorityGroupConfigurator, transitSearchTimeZero, additionalSearchDays, debugTimingAggregator);
        return transitRouter.routeAndCleanupAfter();
    }

    private TransitRouterResult routeAndCleanupAfter() {
        try (TemporaryVerticesContainer temporaryVerticesContainer = this.temporaryVerticesContainer;){
            TransitRouterResult transitRouterResult = this.route();
            return transitRouterResult;
        }
    }

    private TransitRouterResult route() {
        if (!this.request.journey().transit().enabled()) {
            return new TransitRouterResult(List.of(), null);
        }
        if (!this.serverContext.transitService().transitFeedCovers(this.request.dateTime())) {
            throw new RoutingValidationException(List.of(new RoutingError(RoutingErrorCode.OUTSIDE_SERVICE_PERIOD, InputField.DATE_TIME)));
        }
        RaptorTransitData raptorTransitData = this.request.preferences().transit().ignoreRealtimeUpdates() ? this.serverContext.transitService().getRaptorTransitData() : this.serverContext.transitService().getRealtimeRaptorTransitData();
        RaptorRoutingRequestTransitData requestTransitDataProvider = this.createRequestTransitDataProvider(raptorTransitData);
        this.debugTimingAggregator.finishedPatternFiltering();
        AccessEgresses accessEgresses = this.fetchAccessEgresses();
        this.debugTimingAggregator.finishedAccessEgress(accessEgresses.getAccesses().size(), accessEgresses.getEgresses().size());
        RaptorRequest raptorRequest = RaptorRequestMapper.mapRequest(this.request, this.transitSearchTimeZero, this.serverContext.raptorConfig().isMultiThreaded(), accessEgresses.getAccesses(), accessEgresses.getEgresses(), this.serverContext.meterRegistry(), this.viaTransferResolver, this::listStopIndexes);
        RaptorService raptorService = new RaptorService(this.serverContext.raptorConfig(), this.createExtraMcRouterSearch(accessEgresses, raptorTransitData));
        RaptorResponse transitResponse = raptorService.route(raptorRequest, (RaptorTransitDataProvider)requestTransitDataProvider);
        this.checkIfTransitConnectionExists((RaptorResponse<TripSchedule>)transitResponse);
        this.debugTimingAggregator.finishedRaptorSearch();
        List<RaptorPath<TripSchedule>> paths = transitResponse.paths();
        if (OTPFeature.OptimizeTransfers.isOn() && !transitResponse.containsUnknownPaths() && this.request.allowTransferOptimization()) {
            OptimizeTransferService<TripSchedule> service = TransferOptimizationServiceConfigurator.createOptimizeTransferService(raptorTransitData::getStopByIndex, requestTransitDataProvider.stopNameResolver(), this.serverContext.transitService().getTransferService(), requestTransitDataProvider, raptorTransitData.getStopBoardAlightTransferCosts(), this.request.preferences().transfer().optimization(), raptorRequest.searchParams().viaLocations());
            paths = service.optimize(transitResponse.paths());
        }
        RaptorPathToItineraryMapper itineraryMapper = new RaptorPathToItineraryMapper(this.serverContext.graph(), this.serverContext.transitService(), raptorTransitData, this.transitSearchTimeZero, this.request);
        List<Itinerary> itineraries = paths.stream().map(itineraryMapper::createItinerary).toList();
        this.debugTimingAggregator.finishedItineraryCreation();
        return new TransitRouterResult(itineraries, transitResponse.requestUsed().searchParams());
    }

    private AccessEgresses fetchAccessEgresses() {
        ArrayList<RoutingAccessEgress> accessList = new ArrayList<RoutingAccessEgress>();
        ArrayList<RoutingAccessEgress> egressList = new ArrayList<RoutingAccessEgress>();
        if (OTPFeature.ParallelRouting.isOn()) {
            try {
                CompletableFuture.allOf(CompletableFuture.runAsync(() -> accessList.addAll(this.fetchAccess())), CompletableFuture.runAsync(() -> egressList.addAll(this.fetchEgress()))).join();
            }
            catch (CompletionException e) {
                RoutingValidationException.unwrapAndRethrowCompletionException(e);
            }
        } else {
            accessList.addAll(this.fetchAccess());
            egressList.addAll(this.fetchEgress());
        }
        this.verifyAccessEgress(accessList, egressList);
        AccessEgressPenaltyDecorator penaltyDecorator = new AccessEgressPenaltyDecorator(this.request.journey().access().mode(), this.request.journey().egress().mode(), this.request.preferences().street().accessEgress().penalty());
        Collection<? extends RoutingAccessEgress> accessListWithPenalty = penaltyDecorator.decorateAccess(accessList);
        Collection<? extends RoutingAccessEgress> egressListWithPenalty = penaltyDecorator.decorateEgress(egressList);
        return new AccessEgresses(accessListWithPenalty, egressListWithPenalty);
    }

    private Collection<? extends RoutingAccessEgress> fetchAccess() {
        this.debugTimingAggregator.startedAccessCalculating();
        Collection<? extends RoutingAccessEgress> list = this.fetchAccessEgresses(AccessEgressType.ACCESS);
        this.debugTimingAggregator.finishedAccessCalculating();
        return list;
    }

    private Collection<? extends RoutingAccessEgress> fetchEgress() {
        this.debugTimingAggregator.startedEgressCalculating();
        Collection<? extends RoutingAccessEgress> list = this.fetchAccessEgresses(AccessEgressType.EGRESS);
        this.debugTimingAggregator.finishedEgressCalculating();
        return list;
    }

    private Collection<? extends RoutingAccessEgress> fetchAccessEgresses(AccessEgressType type) {
        StreetRequest streetRequest = type.isAccess() ? this.request.journey().access() : this.request.journey().egress();
        StreetMode mode = streetRequest.mode();
        RouteRequestBuilder accessBuilder = this.request.copyOf();
        if (type.isAccess()) {
            accessBuilder.withPreferences(p -> {
                p.withBike(b -> b.withRental(r -> r.withAllowArrivingInRentedVehicleAtDestination(false)));
                p.withCar(c -> c.withRental(r -> r.withAllowArrivingInRentedVehicleAtDestination(false)));
                p.withScooter(s -> s.withRental(r -> r.withAllowArrivingInRentedVehicleAtDestination(false)));
            });
        }
        RouteRequest accessRequest = accessBuilder.buildRequest();
        AccessEgressPreferences accessEgressPreferences = accessRequest.preferences().street().accessEgress();
        Duration durationLimit = accessEgressPreferences.maxDuration().valueOf(mode);
        int stopCountLimit = accessEgressPreferences.maxStopCountLimit().limitForMode(mode);
        Collection<NearbyStop> nearbyStops = AccessEgressRouter.findAccessEgresses(accessRequest, this.temporaryVerticesContainer, streetRequest, this.serverContext.dataOverlayContext(accessRequest), type, durationLimit, stopCountLimit);
        List<RoutingAccessEgress> accessEgresses = AccessEgressMapper.mapNearbyStops(nearbyStops, type);
        accessEgresses = this.timeshiftRideHailing(streetRequest, type, accessEgresses);
        ArrayList<RoutingAccessEgress> results = new ArrayList<RoutingAccessEgress>(accessEgresses);
        if (OTPFeature.FlexRouting.isOn() && mode == StreetMode.FLEXIBLE) {
            Collection<FlexAccessEgress> flexAccessList = FlexAccessEgressRouter.routeAccessEgress(accessRequest, this.temporaryVerticesContainer, this.serverContext, this.additionalSearchDays, this.serverContext.flexParameters(), this.serverContext.dataOverlayContext(accessRequest), type);
            results.addAll(AccessEgressMapper.mapFlexAccessEgresses(flexAccessList, type));
        }
        return results;
    }

    private List<RoutingAccessEgress> timeshiftRideHailing(StreetRequest streetRequest, AccessEgressType type, List<RoutingAccessEgress> accessEgressList) {
        if (streetRequest.mode() != StreetMode.CAR_HAILING) {
            return accessEgressList;
        }
        return RideHailingAccessShifter.shiftAccesses(type.isAccess(), accessEgressList, this.serverContext.rideHailingServices(), this.request, Instant.now());
    }

    private RaptorRoutingRequestTransitData createRequestTransitDataProvider(RaptorTransitData raptorTransitData) {
        return new RaptorRoutingRequestTransitData(raptorTransitData, this.transitGroupPriorityService, this.transitSearchTimeZero, this.additionalSearchDays.additionalSearchDaysInPast(), this.additionalSearchDays.additionalSearchDaysInFuture(), new RouteRequestTransitDataProviderFilter(this.request), this.request);
    }

    private void verifyAccessEgress(Collection<?> access, Collection<?> egress) {
        boolean egressExist;
        boolean accessExist = !access.isEmpty();
        boolean bl = egressExist = !egress.isEmpty();
        if (accessExist && egressExist) {
            return;
        }
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        if (!accessExist) {
            routingErrors.add(new RoutingError(RoutingErrorCode.NO_STOPS_IN_RANGE, InputField.FROM_PLACE));
        }
        if (!egressExist) {
            routingErrors.add(new RoutingError(RoutingErrorCode.NO_STOPS_IN_RANGE, InputField.TO_PLACE));
        }
        throw new RoutingValidationException(routingErrors);
    }

    private void checkIfTransitConnectionExists(RaptorResponse<TripSchedule> response) {
        if (response.noConnectionFound()) {
            throw new RoutingValidationException(List.of(new RoutingError(RoutingErrorCode.NO_TRANSIT_CONNECTION, null)));
        }
    }

    private TemporaryVerticesContainer createTemporaryVerticesContainer(RouteRequest request, OtpServerRequestContext serverContext) {
        return new TemporaryVerticesContainer(serverContext.graph(), serverContext.vertexLinker(), serverContext.transitService()::findStopOrChildIds, request.from(), request.to(), request.journey().access().mode(), request.journey().egress().mode());
    }

    private IntStream listStopIndexes(FeedScopedId stopLocationId) {
        Collection<StopLocation> stops = this.serverContext.transitService().findStopOrChildStops(stopLocationId);
        if (stops.isEmpty()) {
            throw new EntityNotFoundException("Stop, station, multimodal station or group of stations", stopLocationId);
        }
        return stops.stream().mapToInt(StopLocation::getIndex);
    }

    @Nullable
    private ExtraMcRouterSearch<TripSchedule> createExtraMcRouterSearch(AccessEgresses accessEgresses, RaptorTransitData raptorTransitData) {
        if (OTPFeature.Sorlandsbanen.isOff()) {
            return null;
        }
        SorlandsbanenNorwayService service = this.serverContext.sorlandsbanenService();
        return service == null ? null : service.createExtraMcRouterSearch(this.request, accessEgresses, raptorTransitData);
    }
}

