/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.street.model.RentalFormFactor;

public class StreetModeToFormFactorMapper {
    public static RentalFormFactor map(StreetMode streetMode) {
        return switch (streetMode) {
            default -> throw new MatchException(null, null);
            case StreetMode.BIKE_RENTAL -> RentalFormFactor.BICYCLE;
            case StreetMode.SCOOTER_RENTAL -> RentalFormFactor.SCOOTER;
            case StreetMode.CAR_RENTAL -> RentalFormFactor.CAR;
            case StreetMode.NOT_SET, StreetMode.WALK, StreetMode.BIKE, StreetMode.BIKE_TO_PARK, StreetMode.CAR, StreetMode.CAR_TO_PARK, StreetMode.CAR_PICKUP, StreetMode.CAR_HAILING, StreetMode.FLEXIBLE -> throw new IllegalStateException("Cannot convert street mode %s to a form factor".formatted(streetMode));
        };
    }
}

