/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.DirectionUtils;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.plan.leg.ElevationProfile;
import org.opentripplanner.model.plan.walkstep.RelativeDirection;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.model.plan.walkstep.WalkStepBuilder;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorAlightEdge;
import org.opentripplanner.street.model.edge.FreeEdge;
import org.opentripplanner.street.model.edge.PathwayEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetTransitEntranceLink;
import org.opentripplanner.street.model.vertex.ExitVertex;
import org.opentripplanner.street.model.vertex.StationEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.EntranceBuilder;

public class StatesToWalkStepsMapper {
    private static final double MAX_ZAG_DISTANCE = 30.0;
    private final double ellipsoidToGeoidDifference;
    private final StreetNotesService streetNotesService;
    private final List<State> states;
    private final WalkStep previous;
    private final List<WalkStepBuilder> steps = new ArrayList<WalkStepBuilder>();
    private WalkStepBuilder current = null;
    private double lastAngle = 0.0;
    private double distance = 0.0;
    private int roundaboutExit = 0;
    private String roundaboutPreviousStreet = null;

    public StatesToWalkStepsMapper(List<State> states, WalkStep previousStep, StreetNotesService streetNotesService, double ellipsoidToGeoidDifference) {
        this.states = states;
        this.previous = previousStep;
        this.streetNotesService = streetNotesService;
        this.ellipsoidToGeoidDifference = ellipsoidToGeoidDifference;
    }

    public static String getNormalizedName(String streetName) {
        if (streetName == null) {
            return null;
        }
        int idx = streetName.indexOf(40);
        if (idx > 0) {
            return streetName.substring(0, idx - 1);
        }
        return streetName;
    }

    public List<WalkStep> generateWalkSteps() {
        for (int i = 0; i < this.states.size() - 1; ++i) {
            this.processState(this.states.get(i), this.states.get(i + 1));
        }
        return this.steps.stream().map(WalkStepBuilder::build).toList();
    }

    private static boolean isUTurn(WalkStepBuilder twoBack, WalkStepBuilder lastStep) {
        RelativeDirection d1 = lastStep.relativeDirection();
        RelativeDirection d2 = twoBack.relativeDirection();
        return !((d1 != RelativeDirection.RIGHT && d1 != RelativeDirection.HARD_RIGHT || d2 != RelativeDirection.RIGHT && d2 != RelativeDirection.HARD_RIGHT) && (d1 != RelativeDirection.LEFT && d1 != RelativeDirection.HARD_LEFT || d2 != RelativeDirection.LEFT && d2 != RelativeDirection.HARD_LEFT));
    }

    private static double getAbsoluteAngleDiff(double thisAngle, double lastAngle) {
        double ccwAngleDiff;
        double angleDiff = thisAngle - lastAngle;
        if (angleDiff < 0.0) {
            angleDiff += Math.PI * 2;
        }
        if ((ccwAngleDiff = Math.PI * 2 - angleDiff) < angleDiff) {
            angleDiff = ccwAngleDiff;
        }
        return angleDiff;
    }

    private static boolean isLink(Edge edge) {
        StreetEdge streetEdge;
        return edge instanceof StreetEdge && (streetEdge = (StreetEdge)edge).isLink();
    }

    private static ElevationProfile encodeElevationProfile(Edge edge, double distanceOffset, double heightOffset) {
        if (!(edge instanceof StreetEdge)) {
            return ElevationProfile.empty();
        }
        StreetEdge elevEdge = (StreetEdge)edge;
        if (elevEdge.getElevationProfile() == null) {
            return ElevationProfile.empty();
        }
        ElevationProfile.Builder out = ElevationProfile.of();
        for (Coordinate coordinate : elevEdge.getElevationProfile().toCoordinateArray()) {
            out.step(coordinate.x + distanceOffset, coordinate.y + heightOffset);
        }
        return out.build();
    }

    private void processState(State backState, State forwardState) {
        boolean modeTransition;
        PathwayEdge pwe;
        Edge edge = forwardState.getBackEdge();
        boolean createdNewStep = false;
        if (edge instanceof FreeEdge) {
            return;
        }
        if (edge instanceof StreetTransitEntranceLink) {
            StreetTransitEntranceLink link = (StreetTransitEntranceLink)edge;
            RelativeDirection direction = StatesToWalkStepsMapper.relativeDirectionForTransitLink(link);
            this.createAndSaveStep(backState, forwardState, link.getName(), direction, edge, link.entrance());
            return;
        }
        if (forwardState.getBackMode() == null) {
            return;
        }
        LineString geom = edge.getGeometry();
        if (geom == null) {
            return;
        }
        if (edge instanceof ElevatorAlightEdge) {
            this.addStep(this.createElevatorWalkStep(backState, forwardState, edge));
            return;
        }
        Vertex vertex = backState.getVertex();
        if (vertex instanceof StationEntranceVertex) {
            StationEntranceVertex stationEntranceVertex = (StationEntranceVertex)vertex;
            this.addStep(this.createStationEntranceWalkStep(backState, forwardState, stationEntranceVertex));
            return;
        }
        if (edge instanceof PathwayEdge && (pwe = (PathwayEdge)edge).signpostedAs().isPresent()) {
            this.createAndSaveStep(backState, forwardState, pwe.signpostedAs().get(), RelativeDirection.FOLLOW_SIGNS, edge, null);
            return;
        }
        String streetName = edge.getName().toString();
        String streetNameNoParens = StatesToWalkStepsMapper.getNormalizedName(streetName);
        boolean bl = modeTransition = forwardState.getBackMode() != backState.getBackMode();
        if (this.current == null) {
            this.createFirstStep(backState, forwardState);
            createdNewStep = true;
        } else if (modeTransition || !this.continueOnSameStreet(edge, streetNameNoParens) || edge.isRoundabout() != this.roundaboutExit > 0 || StatesToWalkStepsMapper.isLink(edge) && !StatesToWalkStepsMapper.isLink(backState.getBackEdge())) {
            if (this.roundaboutExit > 0) {
                this.current.withExit(Integer.toString(this.roundaboutExit));
                if (streetNameNoParens.equals(this.roundaboutPreviousStreet)) {
                    this.current.withStayOn(true);
                }
                this.roundaboutExit = 0;
            }
            this.current = this.createWalkStep(forwardState, backState);
            createdNewStep = true;
            this.steps.add(this.current);
            if (edge.isRoundabout()) {
                this.roundaboutExit = 1;
                this.roundaboutPreviousStreet = StatesToWalkStepsMapper.getNormalizedName(backState.getBackEdge().getName().toString());
            }
            thisAngle = DirectionUtils.getFirstAngle((Geometry)geom);
            this.current.withDirections(this.lastAngle, thisAngle, edge.isRoundabout());
            this.distance = edge.getDistanceMeters();
        } else {
            thisAngle = DirectionUtils.getFirstAngle((Geometry)geom);
            RelativeDirection direction = RelativeDirection.calculate(this.lastAngle, thisAngle, edge.isRoundabout());
            if (edge.isRoundabout()) {
                if (StatesToWalkStepsMapper.multipleTurnOptionsInPreviousState(backState)) {
                    ++this.roundaboutExit;
                }
            } else if (direction != RelativeDirection.CONTINUE && this.isPossibleToTurnToOtherStreet(backState, edge, streetName, thisAngle)) {
                this.current = this.createWalkStep(forwardState, backState);
                createdNewStep = true;
                this.current.withDirections(this.lastAngle, thisAngle, false);
                this.current.withStayOn(true);
                this.steps.add(this.current);
                this.distance = edge.getDistanceMeters();
            }
        }
        this.setMotorwayExit(backState);
        if (createdNewStep && !modeTransition) {
            int lastIndex = this.steps.size() - 1;
            if (lastIndex >= 2) {
                WalkStepBuilder threeBack = this.steps.get(lastIndex - 2);
                WalkStepBuilder twoBack = this.steps.get(lastIndex - 1);
                WalkStepBuilder lastStep = this.steps.get(lastIndex);
                boolean isOnSameStreet = lastStep.directionTextNoParens().equals(threeBack.directionTextNoParens());
                if (twoBack.distance() < 30.0 && isOnSameStreet && !twoBack.hasEntrance()) {
                    if (StatesToWalkStepsMapper.isUTurn(twoBack, lastStep)) {
                        this.steps.remove(lastIndex - 1);
                        this.processUTurn(lastStep, twoBack);
                    } else if (!lastStep.hasEntrance()) {
                        this.steps.remove(lastIndex);
                        this.steps.remove(lastIndex - 1);
                        this.removeZag(threeBack, twoBack);
                    }
                }
            }
        } else {
            if (!createdNewStep && this.current.elevationProfile() != null) {
                this.updateElevationProfile(backState, edge);
            }
            this.distance += edge.getDistanceMeters();
        }
        this.current.addDistance(edge.getDistanceMeters()).addStreetNotes(this.streetNotesService.getNotes(forwardState));
        this.lastAngle = DirectionUtils.getLastAngle((Geometry)geom);
        this.current.addEdge(edge);
    }

    private static RelativeDirection relativeDirectionForTransitLink(StreetTransitEntranceLink link) {
        if (link.isExit()) {
            return RelativeDirection.EXIT_STATION;
        }
        return RelativeDirection.ENTER_STATION;
    }

    private WalkStepBuilder addStep(WalkStepBuilder step) {
        this.current = step;
        this.steps.add(this.current);
        return step;
    }

    private void updateElevationProfile(State backState, Edge edge) {
        ElevationProfile p = StatesToWalkStepsMapper.encodeElevationProfile(edge, this.distance, backState.getPreferences().system().geoidElevation() ? -this.ellipsoidToGeoidDifference : 0.0);
        this.current.addElevation(p);
    }

    private void removeZag(WalkStepBuilder threeBack, WalkStepBuilder twoBack) {
        this.current = threeBack;
        this.current.addDistance(twoBack.distance());
        this.distance += this.current.distance();
        if (twoBack.elevationProfile() != null) {
            if (this.current.elevationProfile() == null) {
                this.current.addElevation(twoBack.elevationProfile());
            } else {
                this.current.addElevation(twoBack.elevationProfile().transformX(this.current.distance()));
            }
        }
    }

    private void processUTurn(WalkStepBuilder lastStep, WalkStepBuilder twoBack) {
        lastStep.addDistance(twoBack.distance());
        if (lastStep.relativeDirection() == RelativeDirection.LEFT || lastStep.relativeDirection() == RelativeDirection.HARD_LEFT) {
            lastStep.withRelativeDirection(RelativeDirection.UTURN_LEFT);
        } else {
            lastStep.withRelativeDirection(RelativeDirection.UTURN_RIGHT);
        }
        lastStep.withStayOn(true);
    }

    private void setMotorwayExit(State backState) {
        State exitState = backState;
        Edge exitEdge = exitState.getBackEdge();
        while (exitEdge instanceof FreeEdge) {
            exitState = exitState.getBackState();
            exitEdge = exitState.getBackEdge();
        }
        if (exitState.getVertex() instanceof ExitVertex) {
            this.current.withExit(((ExitVertex)exitState.getVertex()).getExitName());
        }
    }

    private boolean isPossibleToTurnToOtherStreet(State backState, Edge edge, String streetName, double thisAngle) {
        if (edge instanceof StreetEdge) {
            double angleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(thisAngle, this.lastAngle);
            for (StreetEdge alternative : backState.getVertex().getOutgoingStreetEdges()) {
                if (!this.isTurnToOtherStreet(streetName, angleDiff, alternative)) continue;
                return true;
            }
        } else {
            double angleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(this.lastAngle, thisAngle);
            State twoStatesBack = backState.getBackState();
            Vertex backVertex = twoStatesBack.getVertex();
            for (StreetEdge alternative : backVertex.getOutgoingStreetEdges()) {
                for (StreetEdge innerAlternative : alternative.getToVertex().getOutgoingStreetEdges()) {
                    if (!this.isTurnToOtherStreet(streetName, angleDiff, innerAlternative)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isTurnToOtherStreet(String streetName, double angleDiff, Edge alternative) {
        if (alternative.getName().toString().equals(streetName)) {
            return false;
        }
        double altAngle = DirectionUtils.getFirstAngle((Geometry)alternative.getGeometry());
        double altAngleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(altAngle, this.lastAngle);
        return angleDiff > 0.7853981633974483 || altAngleDiff - angleDiff < 0.19634954084936207;
    }

    private boolean continueOnSameStreet(Edge edge, String streetNameNoParens) {
        return this.current.directionText().toString() == null || Objects.equals(this.current.directionTextNoParens(), streetNameNoParens) || this.current.nameIsDerived() && edge.nameIsDerived();
    }

    private static boolean multipleTurnOptionsInPreviousState(State state) {
        boolean foundAlternatePaths = false;
        TraverseMode requestedMode = state.currentMode();
        for (Edge out : state.getBackState().getVertex().getOutgoing()) {
            State outState;
            State[] outStates;
            if (out == state.backEdge || !(out instanceof StreetEdge) || State.isEmpty(outStates = (State[])out.traverse(state.getBackState())) || !(outState = outStates[0]).getBackMode().equals((Object)requestedMode)) continue;
            Vertex tov = outState.getVertex();
            boolean found = false;
            for (Edge out2 : tov.getOutgoing()) {
                State[] outStates2 = (State[])out2.traverse(outState);
                if (!State.isEmpty(outStates2) && !Objects.equals((Object)outStates2[0].getBackMode(), (Object)requestedMode)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            foundAlternatePaths = true;
            break;
        }
        return foundAlternatePaths;
    }

    private void createFirstStep(State backState, State forwardState) {
        this.current = this.createWalkStep(forwardState, backState);
        Edge edge = forwardState.getBackEdge();
        double thisAngle = DirectionUtils.getFirstAngle((Geometry)edge.getGeometry());
        if (this.previous == null) {
            this.current.withAbsoluteDirection(thisAngle);
            this.current.withRelativeDirection(RelativeDirection.DEPART);
        } else {
            this.current.withDirections(this.previous.getAngle(), thisAngle, false);
        }
        this.distance = edge.getDistanceMeters();
        this.steps.add(this.current);
    }

    private WalkStepBuilder createElevatorWalkStep(State backState, State forwardState, Edge edge) {
        WalkStepBuilder step = this.createWalkStep(forwardState, backState);
        step.withDirectionText(edge.getName());
        step.withRelativeDirection(RelativeDirection.ELEVATOR);
        return step;
    }

    private WalkStepBuilder createStationEntranceWalkStep(State backState, State forwardState, StationEntranceVertex vertex) {
        Entrance entrance = (Entrance)((EntranceBuilder)((EntranceBuilder)((EntranceBuilder)Entrance.of(vertex.id()).withCode(vertex.code())).withCoordinate(new WgsCoordinate(vertex.getCoordinate()))).withWheelchairAccessibility(vertex.wheelchairAccessibility())).build();
        return this.createWalkStep(forwardState, backState).withRelativeDirection(RelativeDirection.ENTER_OR_EXIT_STATION).withEntrance(entrance);
    }

    private void createAndSaveStep(State backState, State forwardState, I18NString name, RelativeDirection direction, Edge edge, @Nullable Entrance entrance) {
        this.addStep(this.createWalkStep(forwardState, backState).withDirectionText(name).withNameIsDerived(false).withDirections(this.lastAngle, DirectionUtils.getFirstAngle((Geometry)edge.getGeometry()), false).withRelativeDirection(direction).withEntrance(entrance).addDistance(edge.getDistanceMeters()));
        this.lastAngle = DirectionUtils.getLastAngle((Geometry)edge.getGeometry());
        this.distance = edge.getDistanceMeters();
        this.current.addEdge(edge);
    }

    private WalkStepBuilder createWalkStep(State forwardState, State backState) {
        Edge en = forwardState.getBackEdge();
        return WalkStep.builder().withDirectionText(en.getName()).withStartLocation(new WgsCoordinate(backState.getVertex().getCoordinate())).withNameIsDerived(en.nameIsDerived()).withAngle(DirectionUtils.getFirstAngle((Geometry)forwardState.getBackEdge().getGeometry())).withWalkingBike(forwardState.isBackWalkingBike()).withArea(forwardState.getBackEdge() instanceof AreaEdge).addElevation(StatesToWalkStepsMapper.encodeElevationProfile(forwardState.getBackEdge(), 0.0, forwardState.getPreferences().system().geoidElevation() ? -this.ellipsoidToGeoidDifference : 0.0)).addStreetNotes(this.streetNotesService.getNotes(forwardState));
    }
}

