/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.List;
import java.util.Set;
import org.opentripplanner.ext.realtimeresolver.RealtimeResolver;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.TripPlan;
import org.opentripplanner.model.plan.paging.cursor.PageCursor;
import org.opentripplanner.routing.algorithm.mapping.TripPlanMapper;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.api.response.TripSearchMetadata;
import org.opentripplanner.routing.framework.DebugTimingAggregator;
import org.opentripplanner.service.paging.PagingService;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingResponseMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingResponseMapper.class);

    public static RoutingResponse map(RouteRequest request, List<Itinerary> itineraries, Set<RoutingError> routingErrors, DebugTimingAggregator debugTimingAggregator, TransitService transitService, PagingService pagingService) {
        if (request.preferences().transit().ignoreRealtimeUpdates() && OTPFeature.RealtimeResolver.isOn()) {
            itineraries = RealtimeResolver.populateLegsWithRealtime(itineraries, transitService);
        }
        TripPlan tripPlan = TripPlanMapper.mapTripPlan(request, itineraries);
        PageCursor nextPageCursor = pagingService.nextPageCursor();
        PageCursor prevPageCursor = pagingService.previousPageCursor();
        if (LOG.isDebugEnabled()) {
            RoutingResponseMapper.logPagingInformation(request.pageCursor(), prevPageCursor, nextPageCursor, routingErrors);
        }
        TripSearchMetadata metadata = pagingService.createTripSearchMetadata();
        return new RoutingResponse(tripPlan, prevPageCursor, nextPageCursor, metadata, List.copyOf(routingErrors), debugTimingAggregator);
    }

    private static void logPagingInformation(PageCursor currentPageCursor, PageCursor prevPageCursor, PageCursor nextPageCursor, Set<RoutingError> errors) {
        LOG.debug("PageCursor current  : {}", (Object)currentPageCursor);
        LOG.debug("PageCursor previous : {}", (Object)prevPageCursor);
        LOG.debug("PageCursor next ... : {}", (Object)nextPageCursor);
        LOG.debug("Errors ............ : {}", errors);
    }
}

