/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItineraryBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.leg.FrequencyTransitLegBuilder;
import org.opentripplanner.model.plan.leg.LegConstructionSupport;
import org.opentripplanner.model.plan.leg.ScheduledTransitLegBuilder;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.model.plan.leg.UnknownPathLeg;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.EgressPathLeg;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.TransferPathLeg;
import org.opentripplanner.raptor.api.path.TransitPathLeg;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.mapping.StreetModeToTransferTraverseModeMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultRaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.transferoptimization.api.OptimizedPath;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.via.model.ViaCoordinateTransfer;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.request.StreetSearchRequestMapper;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.collection.ListUtils;

public class RaptorPathToItineraryMapper<T extends TripSchedule> {
    private final RaptorTransitData raptorTransitData;
    private final RouteRequest request;
    private final StreetSearchRequest transferStreetRequest;
    private final StreetMode transferMode;
    private final ZonedDateTime transitSearchTimeZero;
    private final GraphPathToItineraryMapper graphPathToItineraryMapper;
    private final TransitService transitService;

    public RaptorPathToItineraryMapper(Graph graph, TransitService transitService, RaptorTransitData raptorTransitData, ZonedDateTime transitSearchTimeZero, RouteRequest request) {
        this.raptorTransitData = raptorTransitData;
        this.transitSearchTimeZero = transitSearchTimeZero;
        this.transferMode = request.journey().transfer().mode();
        this.request = request;
        this.transferStreetRequest = StreetSearchRequestMapper.mapToTransferRequest(request).build();
        this.graphPathToItineraryMapper = new GraphPathToItineraryMapper(transitService.getTimeZone(), graph.streetNotesService, graph.ellipsoidToGeoidDifference);
        this.transitService = transitService;
    }

    public Itinerary createItinerary(RaptorPath<T> path) {
        if (path.isUnknownPath()) {
            return this.mapUnknownRaptorPath(path);
        }
        OptimizedPath optimizedPath = path instanceof OptimizedPath ? (OptimizedPath)path : null;
        AccessPathLeg accessPathLeg = Objects.requireNonNull(path.accessLeg());
        ArrayList<Leg> legs = new ArrayList<Leg>(this.mapAccessLeg(accessPathLeg));
        PathLeg pathLeg = path.accessLeg().nextLeg();
        Leg transitLeg = null;
        PathLeg previousLeg = null;
        while (!pathLeg.isEgressLeg()) {
            if (pathLeg.isTransitLeg()) {
                if (OTPFeature.ExtraTransferLegOnSameStop.isOn() && RaptorPathToItineraryMapper.isPathTransferAtSameStop(previousLeg, pathLeg)) {
                    legs.add(this.createTransferLegAtSameStop(previousLeg, pathLeg));
                }
                transitLeg = this.mapTransitLeg(transitLeg, pathLeg.asTransitLeg());
                legs.add(transitLeg);
            } else if (pathLeg.isTransferLeg() && this.includeTransferInItinerary(transitLeg)) {
                legs.addAll(this.mapTransferLeg(pathLeg.asTransferLeg(), StreetModeToTransferTraverseModeMapper.map(this.transferMode)));
            }
            previousLeg = pathLeg;
            pathLeg = pathLeg.nextLeg();
        }
        EgressPathLeg egressPathLeg = pathLeg.asEgressLeg();
        Itinerary mapped = this.mapEgressLeg(egressPathLeg);
        legs.addAll(mapped == null ? List.of() : mapped.legs());
        Cost generalizedCost = Cost.costOfCentiSeconds(path.c1());
        TimeAndCost accessPenalty = this.mapAccessEgressPenalty(accessPathLeg.access());
        TimeAndCost egressPenalty = this.mapAccessEgressPenalty(egressPathLeg.egress());
        ItineraryBuilder builder = Itinerary.ofScheduledTransit(legs).withGeneralizedCost(generalizedCost).withAccessPenalty(accessPenalty).withEgressPenalty(egressPenalty);
        builder.withArrivedAtDestinationWithRentedVehicle(mapped != null && mapped.isArrivedAtDestinationWithRentedVehicle());
        if (optimizedPath != null) {
            builder.withWaitTimeOptimizedCost(RaptorCostConverter.toOtpDomainCost((int)optimizedPath.generalizedCostWaitTimeOptimized()));
            builder.withTransferPriorityCost(RaptorCostConverter.toOtpDomainCost((int)optimizedPath.transferPriorityCost()));
        }
        if (path.isC2Set()) {
            builder.withGeneralizedCost2(path.c2());
        }
        return builder.build();
    }

    private static <T extends TripSchedule> boolean isPathTransferAtSameStop(PathLeg<T> previousLeg, PathLeg<T> currentLeg) {
        return previousLeg != null && previousLeg.isTransitLeg() && currentLeg.isTransitLeg() && !previousLeg.asTransitLeg().isStaySeatedOntoNextLeg() && previousLeg.asTransitLeg().toStop() == currentLeg.asTransitLeg().fromStop();
    }

    private List<Leg> mapAccessLeg(AccessPathLeg<T> accessPathLeg) {
        if (accessPathLeg.access().isFree()) {
            return List.of();
        }
        Itinerary subItinerary = this.mapAccessEgressPathLeg(accessPathLeg.access());
        if (subItinerary.legs().isEmpty()) {
            return List.of();
        }
        int fromTime = accessPathLeg.fromTime();
        return subItinerary.withTimeShiftToStartAt(this.createZonedDateTime(fromTime)).legs();
    }

    private Leg mapTransitLeg(Leg prevTransitLeg, TransitPathLeg<T> pathLeg) {
        TripSchedule tripSchedule = (TripSchedule)pathLeg.trip();
        int lastLegCost = 0;
        PathLeg nextLeg = pathLeg.nextLeg();
        if (nextLeg.isEgressLeg() && this.isFree(nextLeg.asEgressLeg())) {
            lastLegCost = pathLeg.nextLeg().c1();
        }
        int boardStopIndexInPattern = tripSchedule.findDepartureStopPosition(pathLeg.fromTime(), pathLeg.fromStop());
        int alightStopIndexInPattern = tripSchedule.findArrivalStopPosition(pathLeg.toTime(), pathLeg.toStop());
        double distanceMeters = LegConstructionSupport.computeDistanceMeters(tripSchedule.getOriginalTripPattern(), boardStopIndexInPattern, alightStopIndexInPattern);
        if (tripSchedule.isFrequencyBasedTrip()) {
            int frequencyHeadwayInSeconds = tripSchedule.frequencyHeadwayInSeconds();
            return ((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)((FrequencyTransitLegBuilder)new FrequencyTransitLegBuilder().withTripTimes(tripSchedule.getOriginalTripTimes())).withTripPattern(tripSchedule.getOriginalTripPattern())).withBoardStopIndexInPattern(boardStopIndexInPattern)).withAlightStopIndexInPattern(alightStopIndexInPattern)).withStartTime(this.createZonedDateTime(pathLeg.fromTime() + frequencyHeadwayInSeconds))).withEndTime(this.createZonedDateTime(pathLeg.toTime()))).withDistanceMeters(distanceMeters)).withServiceDate(tripSchedule.getServiceDate())).withZoneId(this.transitSearchTimeZero.getZone().normalized())).withTransferFromPreviousLeg(prevTransitLeg == null ? null : prevTransitLeg.transferToNextLeg())).withTransferToNextLeg((ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg())).withGeneralizedCost(RaptorCostConverter.toOtpDomainCost((int)(pathLeg.c1() + lastLegCost)))).withFrequencyHeadwayInSeconds(frequencyHeadwayInSeconds).build();
        }
        TripOnServiceDate tripOnServiceDate = this.getTripOnServiceDate(tripSchedule);
        return ((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)new ScheduledTransitLegBuilder().withTripTimes(tripSchedule.getOriginalTripTimes())).withTripPattern(tripSchedule.getOriginalTripPattern())).withBoardStopIndexInPattern(boardStopIndexInPattern)).withAlightStopIndexInPattern(alightStopIndexInPattern)).withStartTime(this.createZonedDateTime(pathLeg.fromTime()))).withEndTime(this.createZonedDateTime(pathLeg.toTime()))).withDistanceMeters(distanceMeters)).withServiceDate(tripSchedule.getServiceDate())).withZoneId(this.transitSearchTimeZero.getZone().normalized())).withTripOnServiceDate(tripOnServiceDate)).withTransferFromPreviousLeg(prevTransitLeg == null ? null : prevTransitLeg.transferToNextLeg())).withTransferToNextLeg((ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg())).withGeneralizedCost(RaptorCostConverter.toOtpDomainCost((int)(pathLeg.c1() + lastLegCost)))).build();
    }

    private TripOnServiceDate getTripOnServiceDate(T tripSchedule) {
        if (tripSchedule.getOriginalTripTimes() == null) {
            return null;
        }
        TripIdAndServiceDate tripIdAndServiceDate = new TripIdAndServiceDate(tripSchedule.getOriginalTripTimes().getTrip().getId(), tripSchedule.getServiceDate());
        return this.transitService.getTripOnServiceDate(tripIdAndServiceDate);
    }

    private boolean isFree(EgressPathLeg<T> egressPathLeg) {
        return egressPathLeg.egress().isFree();
    }

    private Leg createTransferLegAtSameStop(PathLeg<T> previousLeg, PathLeg<T> nextLeg) {
        Place transferStop = Place.forStop(this.raptorTransitData.getStopByIndex(previousLeg.toStop()));
        return StreetLeg.of().withMode(TraverseMode.WALK).withStartTime(this.createZonedDateTime(previousLeg.toTime())).withEndTime(this.createZonedDateTime(nextLeg.fromTime())).withFrom(transferStop).withTo(transferStop).withDistanceMeters(0.0).withGeneralizedCost(0).withGeometry(GeometryUtils.makeLineString(transferStop.coordinate, transferStop.coordinate)).withWalkSteps(List.of()).build();
    }

    private List<Leg> mapTransferLeg(TransferPathLeg<T> pathLeg, TraverseMode transferMode) {
        StopLocation transferFromStop = this.raptorTransitData.getStopByIndex(pathLeg.fromStop());
        StopLocation transferToStop = this.raptorTransitData.getStopByIndex(pathLeg.toStop());
        RaptorTransfer raptorTransfer = pathLeg.transfer();
        Place from = Place.forStop(transferFromStop);
        Place to = Place.forStop(transferToStop);
        if (raptorTransfer instanceof DefaultRaptorTransfer) {
            DefaultRaptorTransfer dftTx = (DefaultRaptorTransfer)raptorTransfer;
            return this.mapTransferLeg((PathLeg<T>)pathLeg, dftTx.transfer(), transferMode, from, to);
        }
        if (raptorTransfer instanceof ViaCoordinateTransfer) {
            ViaCoordinateTransfer viaTx = (ViaCoordinateTransfer)raptorTransfer;
            return this.mapViaCoordinateTransferLeg((PathLeg<T>)pathLeg, viaTx, transferMode, from, to);
        }
        throw new IllegalArgumentException("Unknown transfer type: " + String.valueOf(raptorTransfer.getClass()));
    }

    private Itinerary mapEgressLeg(EgressPathLeg<T> egressPathLeg) {
        if (this.isFree(egressPathLeg)) {
            return null;
        }
        Itinerary subItinerary = this.mapAccessEgressPathLeg(egressPathLeg.egress());
        if (subItinerary.legs().isEmpty()) {
            return null;
        }
        return subItinerary.withTimeShiftToStartAt(this.createZonedDateTime(egressPathLeg.fromTime()));
    }

    private List<Leg> mapTransferLeg(PathLeg<T> pathLeg, Transfer transfer, TraverseMode transferMode, Place from, Place to) {
        List<Edge> edges = transfer.getEdges();
        if (edges == null || edges.isEmpty()) {
            return List.of(StreetLeg.of().withMode(transferMode).withStartTime(this.createZonedDateTime(pathLeg.fromTime())).withEndTime(this.createZonedDateTime(pathLeg.toTime())).withFrom(from).withTo(to).withDistanceMeters(transfer.getDistanceMeters()).withGeneralizedCost(RaptorCostConverter.toOtpDomainCost((int)pathLeg.c1())).withGeometry(GeometryUtils.makeLineString(transfer.getCoordinates())).withWalkSteps(List.of()).build());
        }
        return this.mapTransferLegWithEdges(pathLeg.fromTime(), edges);
    }

    private List<Leg> mapViaCoordinateTransferLeg(PathLeg<T> pathLeg, ViaCoordinateTransfer transfer, TraverseMode transferMode, Place from, Place to) {
        List<Leg> fromLegs = this.mapTransferLegWithEdges(pathLeg.fromTime(), transfer.fromEdges());
        List<Leg> toLegs = this.mapTransferLegWithEdges(pathLeg.toTime(), transfer.toEdges());
        if (fromLegs.isEmpty() || toLegs.isEmpty()) {
            throw new IllegalStateException("There need to be at least one edge to get from a stop to the via coordinate and back");
        }
        long toDuration = toLegs.stream().mapToLong(l -> l.duration().toSeconds()).sum();
        toLegs = toLegs.stream().map(l -> l.withTimeShift(Duration.ofSeconds(-toDuration))).toList();
        return ListUtils.combine((Collection[])new Collection[]{fromLegs, toLegs});
    }

    private List<Leg> mapTransferLegWithEdges(int fromTime, List<Edge> edges) {
        StateEditor se = new StateEditor(edges.getFirst().getFromVertex(), this.transferStreetRequest);
        se.setTimeSeconds(this.createZonedDateTime(fromTime).toEpochSecond());
        State s = se.makeState();
        ArrayList<State> transferStates = new ArrayList<State>();
        transferStates.add(s);
        for (Edge e : edges) {
            State[] states = (State[])e.traverse(s);
            if (State.isEmpty(states)) {
                s = null;
                continue;
            }
            transferStates.add(states[0]);
            s = states[0];
        }
        State[] states = (State[])transferStates.toArray(State[]::new);
        GraphPath<State, Edge, Vertex> graphPath = new GraphPath<State, Edge, Vertex>(states[states.length - 1]);
        Itinerary subItinerary = this.graphPathToItineraryMapper.generateItinerary(graphPath);
        return subItinerary.legs();
    }

    private Itinerary mapUnknownRaptorPath(RaptorPath<T> path) {
        List<Leg> legs = List.of(new UnknownPathLeg(this.mapPlace(this.request.from()), this.mapPlace(this.request.to()), this.createZonedDateTime(path.startTime()), this.createZonedDateTime(path.endTime()), path.numberOfTransfers()));
        Cost generalizedCost = Cost.costOfCentiSeconds(path.c1());
        return Itinerary.ofScheduledTransit(legs).withGeneralizedCost(generalizedCost).build();
    }

    private Place mapPlace(GenericLocation location) {
        return Place.normal(location.lat, location.lng, new NonLocalizedString(location.label));
    }

    private ZonedDateTime createZonedDateTime(int timeInSeconds) {
        return this.transitSearchTimeZero.plusSeconds(timeInSeconds);
    }

    private boolean includeTransferInItinerary(Leg transitLegBeforeTransfer) {
        return transitLegBeforeTransfer == null || transitLegBeforeTransfer.transferToNextLeg() == null || !transitLegBeforeTransfer.transferToNextLeg().getTransferConstraint().isStaySeated();
    }

    private Itinerary mapAccessEgressPathLeg(RaptorAccessEgress accessEgress) {
        return accessEgress.findOriginal(RoutingAccessEgress.class).map(RoutingAccessEgress::getLastState).map(GraphPath::new).map(this.graphPathToItineraryMapper::generateItinerary).orElseThrow();
    }

    private TimeAndCost mapAccessEgressPenalty(RaptorAccessEgress accessEgress) {
        return accessEgress.findOriginal(RoutingAccessEgress.class).map(RoutingAccessEgress::penalty).orElseThrow();
    }
}

