/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalDouble;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.street.model.edge.StreetEdge;

public class ItinerariesHelper {
    public static List<Itinerary> decorateItinerariesWithRequestData(List<Itinerary> itineraries, boolean wheelchairEnabled, WheelchairPreferences wheelchairPreferences) {
        if (!wheelchairEnabled) {
            return itineraries;
        }
        ArrayList<Itinerary> result = new ArrayList<Itinerary>();
        boolean dirty = false;
        for (Itinerary it : itineraries) {
            OptionalDouble maxSlope = ItinerariesHelper.getMaxSlope(it);
            if (maxSlope.isPresent()) {
                dirty = true;
                itineraries.add(it.copyOf().withMaxSlope(wheelchairPreferences.maxSlope(), maxSlope.getAsDouble()).build());
                continue;
            }
            result.add(it);
        }
        return dirty ? result : itineraries;
    }

    private static OptionalDouble getMaxSlope(Itinerary it) {
        return it.legs().stream().filter(StreetLeg.class::isInstance).map(StreetLeg.class::cast).map(StreetLeg::listWalkSteps).flatMap(Collection::stream).map(WalkStep::getEdges).filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).mapToDouble(StreetEdge::getMaxSlope).max();
    }
}

