/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.ext.flex.FlexibleTransitLeg;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.time.ZoneIdFallback;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItineraryBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.leg.ElevationProfile;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.model.plan.leg.StreetLegBuilder;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.routing.algorithm.mapping.StatesToWalkStepsMapper;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalEdge;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.edge.BoardingLocationToStopLink;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.VehicleParkingEdge;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TemporaryStreetLocation;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.VehicleRentalState;

public class GraphPathToItineraryMapper {
    private final ZoneId timeZone;
    private final StreetNotesService streetNotesService;
    private final double ellipsoidToGeoidDifference;

    public GraphPathToItineraryMapper(ZoneId timeZone, StreetNotesService streetNotesService, double ellipsoidToGeoidDifference) {
        this.timeZone = ZoneIdFallback.zoneId(timeZone);
        this.streetNotesService = streetNotesService;
        this.ellipsoidToGeoidDifference = ellipsoidToGeoidDifference;
    }

    public static boolean isRentalPickUp(State state) {
        return state.getBackEdge() instanceof VehicleRentalEdge && (state.getBackState() == null || !state.getBackState().isRentingVehicle());
    }

    public static boolean isRentalStationDropOff(State state) {
        return state.getBackEdge() instanceof VehicleRentalEdge && state.getBackState().isRentingVehicle();
    }

    public static boolean isFloatingRentalDropoff(State state) {
        return !state.isRentingVehicle() && state.getBackState() != null && state.getBackState().getVehicleRentalState() == VehicleRentalState.RENTING_FLOATING;
    }

    public List<Itinerary> mapItineraries(List<GraphPath<State, Edge, Vertex>> paths) {
        LinkedList<Itinerary> itineraries = new LinkedList<Itinerary>();
        for (GraphPath<State, Edge, Vertex> path : paths) {
            Itinerary itinerary = this.generateItinerary(path);
            if (itinerary.legs().isEmpty()) continue;
            itineraries.add(itinerary);
        }
        return itineraries;
    }

    public Itinerary generateItinerary(GraphPath<State, Edge, Vertex> path) {
        ArrayList<Leg> legs = new ArrayList<Leg>();
        WalkStep previousStep = null;
        for (List<State> legStates : GraphPathToItineraryMapper.sliceStates(path.states)) {
            if (OTPFeature.FlexRouting.isOn() && legStates.get((int)1).backEdge instanceof FlexTripEdge) {
                legs.add(this.generateFlexLeg(legStates));
                previousStep = null;
                continue;
            }
            StreetLeg leg = this.generateLeg(legStates, previousStep);
            legs.add(leg);
            List<WalkStep> walkSteps = leg.listWalkSteps();
            if (walkSteps.size() > 0) {
                previousStep = walkSteps.get(walkSteps.size() - 1);
                continue;
            }
            previousStep = null;
        }
        State lastState = (State)path.states.getLast();
        Cost cost = Cost.costOfSeconds(lastState.weight);
        ItineraryBuilder builder = Itinerary.ofDirect(legs).withGeneralizedCost(cost);
        builder.withArrivedAtDestinationWithRentedVehicle(lastState.isRentingVehicleFromStation());
        GraphPathToItineraryMapper.calculateElevations(builder, path.edges);
        return builder.build();
    }

    private static List<List<State>> sliceStates(List<State> states) {
        if (states.stream().allMatch(state -> state.getBackMode() == null)) {
            return List.of();
        }
        LinkedList<List<State>> legsStates = new LinkedList<List<State>>();
        int previousBreak = 0;
        for (int i = 1; i < states.size() - 1; ++i) {
            boolean carPickupChange;
            State backState = states.get(i);
            State forwardState = states.get(i + 1);
            boolean flexChange = forwardState.backEdge instanceof FlexTripEdge || backState.backEdge instanceof FlexTripEdge;
            boolean rentalChange = GraphPathToItineraryMapper.isRentalPickUp(backState) || GraphPathToItineraryMapper.isRentalStationDropOff(backState) || GraphPathToItineraryMapper.isFloatingRentalDropoff(backState);
            boolean parkingChange = backState.isVehicleParked() != forwardState.isVehicleParked();
            boolean bl = carPickupChange = backState.getCarPickupState() != forwardState.getCarPickupState();
            if (!parkingChange && !flexChange && !rentalChange && !carPickupChange) continue;
            int nextBreak = i;
            if (nextBreak > previousBreak) {
                legsStates.add(states.subList(previousBreak, nextBreak + 1));
            }
            if (parkingChange) {
                // empty if block
            }
            previousBreak = ++nextBreak;
        }
        if (states.size() > previousBreak) {
            legsStates.add(states.subList(previousBreak, states.size()));
        }
        return legsStates;
    }

    private static void calculateElevations(ItineraryBuilder builder, List<Edge> edges) {
        for (Edge edge : edges) {
            StreetEdge edgeWithElevation;
            PackedCoordinateSequence coordinates;
            if (!(edge instanceof StreetEdge) || (coordinates = (edgeWithElevation = (StreetEdge)edge).getElevationProfile()) == null || coordinates.getDimension() != 2) continue;
            for (int i = 0; i < coordinates.size() - 1; ++i) {
                double change = coordinates.getOrdinate(i + 1, 1) - coordinates.getOrdinate(i, 1);
                builder.addElevationChange(change);
            }
        }
    }

    private static TraverseMode resolveMode(List<State> states) {
        return states.stream().skip(1L).map(state -> {
            TraverseMode mode = state.currentMode();
            if (mode != null) {
                if (state.isRentingVehicle()) {
                    return state.stateData.rentalVehicleFormFactor.traverseMode;
                }
                return mode;
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(TraverseMode.WALK);
    }

    private static ElevationProfile encodeElevationProfileWithNaN(Edge edge, double distanceOffset, double heightOffset) {
        ElevationProfile elevations = GraphPathToItineraryMapper.encodeElevationProfile(edge, distanceOffset, heightOffset);
        if (elevations.isEmpty()) {
            return ElevationProfile.of().stepYUnknown(distanceOffset).stepYUnknown(distanceOffset + edge.getDistanceMeters()).build();
        }
        return elevations;
    }

    private static ElevationProfile encodeElevationProfile(Edge edge, double distanceOffset, double heightOffset) {
        Coordinate[] coordArr;
        if (!(edge instanceof StreetEdge)) {
            return ElevationProfile.empty();
        }
        StreetEdge elevEdge = (StreetEdge)edge;
        if (elevEdge.getElevationProfile() == null) {
            return ElevationProfile.empty();
        }
        ElevationProfile.Builder out = ElevationProfile.of();
        for (Coordinate coordinate : coordArr = elevEdge.getElevationProfile().toCoordinateArray()) {
            out.step(coordinate.x + distanceOffset, coordinate.y + heightOffset);
        }
        return out.build();
    }

    private static Place makePlace(State state) {
        Vertex vertex = state.getVertex();
        I18NString name = vertex.getName();
        if (vertex instanceof StreetVertex && !(vertex instanceof TemporaryStreetLocation)) {
            name = ((StreetVertex)vertex).getIntersectionName();
        }
        if (vertex instanceof TransitStopVertex) {
            return Place.forStop(((TransitStopVertex)vertex).getStop());
        }
        if (vertex instanceof VehicleRentalPlaceVertex) {
            return Place.forVehicleRentalPlace((VehicleRentalPlaceVertex)vertex);
        }
        if (vertex instanceof VehicleParkingEntranceVertex) {
            return Place.forVehicleParkingEntrance((VehicleParkingEntranceVertex)vertex, state);
        }
        return Place.normal(vertex, name);
    }

    private Leg generateFlexLeg(List<State> states) {
        State fromState = states.get(0);
        State toState = states.get(1);
        FlexTripEdge flexEdge = (FlexTripEdge)toState.backEdge;
        ZonedDateTime startTime = fromState.getTime().atZone(this.timeZone);
        ZonedDateTime endTime = toState.getTime().atZone(this.timeZone);
        int generalizedCost = (int)(toState.getWeight() - fromState.getWeight());
        return FlexibleTransitLeg.of().withFlexTripEdge(flexEdge).withStartTime(startTime).withEndTime(endTime).withGeneralizedCost(generalizedCost).build();
    }

    private StreetLeg generateLeg(List<State> states, WalkStep previousStep) {
        String vehicleRentalNetwork;
        List<Edge> edges = states.stream().skip(1L).filter(e -> !(e.backEdge instanceof BoardingLocationToStopLink)).map(State::getBackEdge).toList();
        State firstState = states.get(0);
        State lastState = states.get(states.size() - 1);
        double distanceMeters = edges.stream().mapToDouble(Edge::getDistanceMeters).sum();
        LineString geometry = GeometryUtils.concatenateLineStrings(edges, Edge::getGeometry);
        StatesToWalkStepsMapper statesToWalkStepsMapper = new StatesToWalkStepsMapper(states, previousStep, this.streetNotesService, this.ellipsoidToGeoidDifference);
        List<WalkStep> walkSteps = statesToWalkStepsMapper.generateWalkSteps();
        boolean previousStateIsVehicleParking = firstState.getBackState() != null && firstState.getBackEdge() instanceof VehicleParkingEdge;
        State startTimeState = previousStateIsVehicleParking ? firstState.getBackState() : firstState;
        StreetLegBuilder leg = StreetLeg.of().withMode(GraphPathToItineraryMapper.resolveMode(states)).withStartTime(startTimeState.getTime().atZone(this.timeZone)).withEndTime(lastState.getTime().atZone(this.timeZone)).withFrom(GraphPathToItineraryMapper.makePlace(firstState)).withTo(GraphPathToItineraryMapper.makePlace(lastState)).withDistanceMeters(distanceMeters).withGeneralizedCost((int)(lastState.getWeight() - firstState.getWeight())).withGeometry(geometry).withElevationProfile(this.makeElevation(edges, firstState.getPreferences().system().geoidElevation())).withWalkSteps(walkSteps).withRentedVehicle(firstState.isRentingVehicle()).withWalkingBike(false);
        if (firstState.isRentingVehicle() && (vehicleRentalNetwork = firstState.getVehicleRentalNetwork()) != null) {
            leg.withVehicleRentalNetwork(vehicleRentalNetwork);
        }
        this.addStreetNotes(leg, states);
        return leg.build();
    }

    private void addStreetNotes(StreetLegBuilder leg, List<State> states) {
        for (State state : states) {
            Set<StreetNote> streetNotes = this.streetNotesService.getNotes(state);
            if (streetNotes == null) continue;
            leg.withStreetNotes(streetNotes);
        }
    }

    private ElevationProfile makeElevation(List<Edge> edges, boolean geoidElevation) {
        ElevationProfile.Builder builder = ElevationProfile.of();
        double heightOffset = geoidElevation ? this.ellipsoidToGeoidDifference : 0.0;
        double distanceOffset = 0.0;
        for (Edge edge : edges) {
            if (!(edge.getDistanceMeters() > 0.0)) continue;
            builder.add(GraphPathToItineraryMapper.encodeElevationProfileWithNaN(edge, distanceOffset, heightOffset));
            distanceOffset += edge.getDistanceMeters();
        }
        ElevationProfile p = builder.build();
        return p.isAllYUnknown() ? null : p;
    }
}

