/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;

public class AlertToLegMapper {
    private final TransitAlertService transitAlertService;
    private final Function<Station, MultiModalStation> getMultiModalStation;

    public AlertToLegMapper(TransitAlertService transitAlertService, Function<Station, MultiModalStation> getMultiModalStation) {
        this.transitAlertService = transitAlertService;
        this.getMultiModalStation = getMultiModalStation;
    }

    public TransitLeg decorateWithAlerts(TransitLeg leg, boolean isFirstLeg) {
        Collection<TransitAlert> alerts;
        Set<StopCondition> stopConditions;
        RegularStop stop;
        ZonedDateTime legStartTime = leg.startTime();
        ZonedDateTime legEndTime = leg.endTime();
        StopLocation fromStop = leg.from() == null ? null : leg.from().stop;
        StopLocation toStop = leg.to() == null ? null : leg.to().stop;
        FeedScopedId routeId = leg.route().getId();
        FeedScopedId tripId = leg.trip().getId();
        LocalDate serviceDate = leg.serviceDate();
        HashSet<TransitAlert> totalAlerts = new HashSet<TransitAlert>();
        if (fromStop instanceof RegularStop) {
            stop = (RegularStop)fromStop;
            stopConditions = isFirstLeg ? StopCondition.FIRST_DEPARTURE : StopCondition.DEPARTURE;
            alerts = this.getAlertsForStopAndRoute(stop, routeId, stopConditions);
            alerts.addAll(this.getAlertsForStopAndTrip(stop, tripId, serviceDate, stopConditions));
            alerts.addAll(this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAlerts((FeedScopedId)id, stopConditions)));
            totalAlerts.addAll(AlertToLegMapper.filterAlertsByTime(alerts, legStartTime, legEndTime));
        }
        if (toStop instanceof RegularStop) {
            stop = (RegularStop)toStop;
            stopConditions = StopCondition.ARRIVING;
            alerts = this.getAlertsForStopAndRoute(stop, routeId, stopConditions);
            alerts.addAll(this.getAlertsForStopAndTrip(stop, tripId, serviceDate, stopConditions));
            alerts.addAll(this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAlerts((FeedScopedId)id, stopConditions)));
            totalAlerts.addAll(AlertToLegMapper.filterAlertsByTime(alerts, legStartTime, legEndTime));
        }
        if (leg.listIntermediateStops() != null) {
            Set<StopCondition> stopConditions2 = StopCondition.PASSING;
            for (StopArrival visit : leg.listIntermediateStops()) {
                StopLocation stopLocation = visit.place.stop;
                if (!(stopLocation instanceof RegularStop)) continue;
                RegularStop stop2 = (RegularStop)stopLocation;
                Collection<TransitAlert> alerts2 = this.getAlertsForStopAndRoute(stop2, routeId, stopConditions2);
                alerts2.addAll(this.getAlertsForStopAndTrip(stop2, tripId, serviceDate, stopConditions2));
                alerts2.addAll(this.getAlertsForRelatedStops(stop2, id -> this.transitAlertService.getStopAlerts((FeedScopedId)id, stopConditions2)));
                ZonedDateTime stopArrival = visit.arrival.scheduledTime();
                ZonedDateTime stopDeparture = visit.departure.scheduledTime();
                totalAlerts.addAll(AlertToLegMapper.filterAlertsByTime(alerts2, stopArrival, stopDeparture));
            }
        }
        Collection<TransitAlert> alerts3 = this.transitAlertService.getTripAlerts(leg.trip().getId(), serviceDate);
        totalAlerts.addAll(AlertToLegMapper.filterAlertsByTime(alerts3, legStartTime, legEndTime));
        alerts3 = this.transitAlertService.getRouteAlerts(leg.route().getId());
        totalAlerts.addAll(AlertToLegMapper.filterAlertsByTime(alerts3, legStartTime, legEndTime));
        alerts3 = this.transitAlertService.getAgencyAlerts(leg.agency().getId());
        totalAlerts.addAll(AlertToLegMapper.filterAlertsByTime(alerts3, legStartTime, legEndTime));
        totalAlerts.removeIf(alert -> !alert.displayDuring(leg.startTime().toEpochSecond(), leg.endTime().toEpochSecond()));
        return (TransitLeg)leg.decorateWithAlerts(Set.copyOf(totalAlerts));
    }

    private static List<TransitAlert> filterAlertsByTime(Collection<TransitAlert> alerts, ZonedDateTime fromTime, ZonedDateTime toTime) {
        return alerts.stream().filter(alert -> alert.displayDuring(fromTime.toEpochSecond(), toTime.toEpochSecond())).toList();
    }

    private Collection<TransitAlert> getAlertsForStopAndRoute(RegularStop stop, FeedScopedId routeId, Set<StopCondition> stopConditions) {
        return this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAndRouteAlerts((FeedScopedId)id, routeId, stopConditions));
    }

    private Collection<TransitAlert> getAlertsForStopAndTrip(RegularStop stop, FeedScopedId tripId, LocalDate serviceDate, Set<StopCondition> stopConditions) {
        return this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAndTripAlerts((FeedScopedId)id, tripId, serviceDate, stopConditions));
    }

    private Collection<TransitAlert> getAlertsForRelatedStops(RegularStop stop, Function<FeedScopedId, Collection<TransitAlert>> getAlertsForStop) {
        if (stop == null) {
            return new ArrayList<TransitAlert>();
        }
        Collection<TransitAlert> alertsForStop = getAlertsForStop.apply(stop.getId());
        if (alertsForStop == null) {
            alertsForStop = new HashSet<TransitAlert>();
        }
        if (stop.isPartOfStation()) {
            Collection<TransitAlert> multimodalStopAlerts;
            Station parentStation = stop.getParentStation();
            Collection<TransitAlert> parentStopAlerts = getAlertsForStop.apply(parentStation.getId());
            if (parentStopAlerts != null) {
                alertsForStop.addAll(parentStopAlerts);
            }
            for (StopLocation siblingStop : parentStation.getChildStops()) {
                Collection<TransitAlert> siblingAlerts;
                if (stop.getId().equals(siblingStop.getId()) || (siblingAlerts = getAlertsForStop.apply(parentStation.getId())) == null) continue;
                alertsForStop.addAll(siblingAlerts);
            }
            MultiModalStation multiModalStation = this.getMultiModalStation.apply(parentStation);
            if (multiModalStation != null && (multimodalStopAlerts = getAlertsForStop.apply(multiModalStation.getId())) != null) {
                alertsForStop.addAll(multimodalStopAlerts);
            }
        }
        return alertsForStop;
    }
}

