/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.paging;

import java.time.Instant;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.paging.cursor.PageCursorInput;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class DefaultPageCursorInput
implements PageCursorInput {
    private final Instant earliestRemovedDeparture;
    private final Instant latestRemovedDeparture;
    private final ItinerarySortKey pageCut;
    private final Cost generalizedCostMaxLimit;

    private DefaultPageCursorInput() {
        this.earliestRemovedDeparture = null;
        this.latestRemovedDeparture = null;
        this.pageCut = null;
        this.generalizedCostMaxLimit = null;
    }

    private DefaultPageCursorInput(Builder builder) {
        this.earliestRemovedDeparture = builder.earliestRemovedDeparture();
        this.latestRemovedDeparture = builder.latestRemovedDeparture();
        this.pageCut = builder.pageCut();
        this.generalizedCostMaxLimit = builder.generalizedCostMaxLimit();
    }

    public static Builder of() {
        return new Builder(new DefaultPageCursorInput());
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    @Override
    public Instant earliestRemovedDeparture() {
        return this.earliestRemovedDeparture;
    }

    @Override
    public Instant latestRemovedDeparture() {
        return this.latestRemovedDeparture;
    }

    @Override
    public ItinerarySortKey pageCut() {
        return this.pageCut;
    }

    @Override
    public Cost generalizedCostMaxLimit() {
        return this.generalizedCostMaxLimit;
    }

    public String toString() {
        return ToStringBuilder.of(DefaultPageCursorInput.class).addDateTime("earliestRemovedDeparture", this.earliestRemovedDeparture).addDateTime("latestRemovedDeparture", this.latestRemovedDeparture).addObjOp("pageCut", (Object)this.pageCut, ItinerarySortKey::keyAsString).addObj("generalizedCostMaxLimit", (Object)this.generalizedCostMaxLimit).toString();
    }

    public static class Builder {
        private Instant earliestRemovedDeparture;
        private Instant latestRemovedDeparture;
        private ItinerarySortKey pageCut;
        private Cost generalizedCostMaxLimit;

        public Builder(DefaultPageCursorInput original) {
            this.earliestRemovedDeparture = original.earliestRemovedDeparture;
            this.latestRemovedDeparture = original.latestRemovedDeparture;
            this.pageCut = original.pageCut;
            this.generalizedCostMaxLimit = original.generalizedCostMaxLimit;
        }

        public Instant earliestRemovedDeparture() {
            return this.earliestRemovedDeparture;
        }

        public Builder withEarliestRemovedDeparture(Instant earliestRemovedDeparture) {
            this.earliestRemovedDeparture = earliestRemovedDeparture;
            return this;
        }

        public Instant latestRemovedDeparture() {
            return this.latestRemovedDeparture;
        }

        public Builder withLatestRemovedDeparture(Instant latestRemovedDeparture) {
            this.latestRemovedDeparture = latestRemovedDeparture;
            return this;
        }

        public ItinerarySortKey pageCut() {
            return this.pageCut;
        }

        public Builder withPageCut(ItinerarySortKey pageCut) {
            this.pageCut = pageCut;
            return this;
        }

        public Cost generalizedCostMaxLimit() {
            return this.generalizedCostMaxLimit;
        }

        public Builder withGeneralizedCostMaxLimit(Cost generalizedCostMaxLimit) {
            this.generalizedCostMaxLimit = generalizedCostMaxLimit;
            return this;
        }

        public DefaultPageCursorInput build() {
            return new DefaultPageCursorInput(this);
        }
    }
}

