/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.framework.sort;

import java.util.Comparator;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.utils.collection.CompositeComparator;

public class SortOrderComparator
extends CompositeComparator<ItinerarySortKey> {
    static final Comparator<ItinerarySortKey> STREET_ONLY_FIRST_COMP = (a, b) -> Boolean.compare(b.isStreetOnly(), a.isStreetOnly());
    static final Comparator<ItinerarySortKey> ARRIVAL_TIME_COMP = Comparator.comparing(ItinerarySortKey::endTimeAsInstant);
    static final Comparator<ItinerarySortKey> DEPARTURE_TIME_COMP = Comparator.comparing(ItinerarySortKey::startTimeAsInstant).reversed();
    static final Comparator<ItinerarySortKey> GENERALIZED_COST_COMP = Comparator.comparing(ItinerarySortKey::generalizedCostIncludingPenalty);
    static final Comparator<ItinerarySortKey> NUM_OF_TRANSFERS_COMP = Comparator.comparingInt(ItinerarySortKey::numberOfTransfers);
    private static final SortOrderComparator STREET_AND_ARRIVAL_TIME = new SortOrderComparator(STREET_ONLY_FIRST_COMP, ARRIVAL_TIME_COMP, GENERALIZED_COST_COMP, NUM_OF_TRANSFERS_COMP, DEPARTURE_TIME_COMP);
    private static final SortOrderComparator STREET_AND_DEPARTURE_TIME = new SortOrderComparator(STREET_ONLY_FIRST_COMP, DEPARTURE_TIME_COMP, GENERALIZED_COST_COMP, NUM_OF_TRANSFERS_COMP, ARRIVAL_TIME_COMP);
    private static final SortOrderComparator GENERALIZED_COST = new SortOrderComparator(GENERALIZED_COST_COMP, NUM_OF_TRANSFERS_COMP);
    private static final SortOrderComparator NUM_TRANSFERS = new SortOrderComparator(NUM_OF_TRANSFERS_COMP, GENERALIZED_COST_COMP);

    @SafeVarargs
    private SortOrderComparator(Comparator<ItinerarySortKey> ... compareVector) {
        super((Comparator[])compareVector);
    }

    public static SortOrderComparator defaultComparatorDepartAfter() {
        return STREET_AND_ARRIVAL_TIME;
    }

    public static SortOrderComparator defaultComparatorArriveBy() {
        return STREET_AND_DEPARTURE_TIME;
    }

    public static SortOrderComparator generalizedCostComparator() {
        return GENERALIZED_COST;
    }

    public static SortOrderComparator numberOfTransfersComparator() {
        return NUM_TRANSFERS;
    }

    public static SortOrderComparator comparator(SortOrder sortOrder) {
        return switch (sortOrder) {
            default -> throw new MatchException(null, null);
            case SortOrder.STREET_AND_ARRIVAL_TIME -> STREET_AND_ARRIVAL_TIME;
            case SortOrder.STREET_AND_DEPARTURE_TIME -> STREET_AND_DEPARTURE_TIME;
        };
    }
}

