/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.framework.groupids;

import java.util.List;
import java.util.stream.Stream;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.GroupId;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class GroupBySameRoutesAndStops
implements GroupId<GroupBySameRoutesAndStops> {
    public static final String TAG = "group-by-same-stations-and-routes";
    private final List<FeedScopedId> keySet;

    public GroupBySameRoutesAndStops(Itinerary itinerary) {
        this.keySet = itinerary.legs().stream().filter(Leg::isTransitLeg).flatMap(leg -> Stream.of(leg.from().stop.getStationOrStopId(), leg.route().getId(), leg.to().stop.getStationOrStopId())).toList();
    }

    @Override
    public boolean match(GroupBySameRoutesAndStops other) {
        if (this == other) {
            return true;
        }
        if (this.keySet.isEmpty() || other.keySet.isEmpty()) {
            return false;
        }
        return this.keySet.equals(other.keySet);
    }

    @Override
    public GroupBySameRoutesAndStops merge(GroupBySameRoutesAndStops other) {
        return this;
    }
}

