/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.framework.filterchain;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.OutsideSearchWindowFilter;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;

public class RoutingErrorsAttacher {
    public static List<RoutingError> computeErrors(List<Itinerary> originalItineraries, List<Itinerary> filteredItineraries) {
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        Predicate<Itinerary> isOnStreetAllTheWay = Itinerary::isStreetOnly;
        boolean hasTransitItineraries = originalItineraries.stream().anyMatch(Predicate.not(isOnStreetAllTheWay));
        boolean allTransitItinerariesDeleted = filteredItineraries.stream().filter(Predicate.not(isOnStreetAllTheWay)).allMatch(Itinerary::isFlaggedForDeletion);
        if (hasTransitItineraries && allTransitItinerariesDeleted) {
            Predicate<Itinerary> isWorseThanStreet = it -> it.systemNotices().stream().anyMatch(notice -> notice.tag().equals("transit-vs-street-filter"));
            Predicate<Itinerary> isWorseThanWalking = it -> it.systemNotices().stream().anyMatch(notice -> notice.tag().equals("transit-vs-walk-filter"));
            if (filteredItineraries.stream().allMatch(isOnStreetAllTheWay.or(isWorseThanStreet).or(isWorseThanWalking))) {
                boolean nonTransitIsWalking = filteredItineraries.stream().flatMap(Itinerary::streetLegs).allMatch(StreetLeg::isWalkingLeg);
                if (nonTransitIsWalking) {
                    routingErrors.add(new RoutingError(RoutingErrorCode.WALKING_BETTER_THAN_TRANSIT, null));
                }
            } else if (filteredItineraries.stream().allMatch(isOnStreetAllTheWay.or(OutsideSearchWindowFilter::taggedBy))) {
                routingErrors.add(new RoutingError(RoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW, InputField.DATE_TIME));
            }
        }
        return routingErrors;
    }
}

