/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.framework.filter;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryListFilter;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;

public class RemoveFilter
implements ItineraryListFilter {
    private final RemoveItineraryFlagger flagger;

    public RemoveFilter(RemoveItineraryFlagger flagger) {
        this.flagger = flagger;
    }

    public String name() {
        return this.flagger.name();
    }

    @Override
    public List<Itinerary> filter(List<Itinerary> itineraries) {
        List<Itinerary> filterInput = this.flagger.skipAlreadyFlaggedItineraries() ? itineraries.stream().filter(Predicate.not(Itinerary::isFlaggedForDeletion)).collect(Collectors.toList()) : itineraries;
        for (Itinerary it : this.flagger.flagForRemoval(filterInput)) {
            it.flagForDeletion(new SystemNotice(this.flagger.name(), "This itinerary is marked as deleted by the " + this.flagger.name() + " filter."));
        }
        return itineraries;
    }
}

