/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.framework.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.GroupId;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryListFilter;

public class GroupByFilter<T extends GroupId<T>>
implements ItineraryListFilter {
    private final Function<Itinerary, T> groupingBy;
    private final List<ItineraryListFilter> nestedFilters;

    public GroupByFilter(Function<Itinerary, T> groupingBy, List<ItineraryListFilter> nestedFilters) {
        this.groupingBy = groupingBy;
        this.nestedFilters = nestedFilters;
    }

    @Override
    public final List<Itinerary> filter(List<Itinerary> itineraries) {
        ArrayList<Entry> groups = new ArrayList<Entry>();
        for (Itinerary it : itineraries) {
            GroupId groupId = (GroupId)this.groupingBy.apply(it);
            Entry matchFound = null;
            for (Entry e : groups) {
                if (e.itineraries.isEmpty() || !e.match(groupId)) continue;
                if (matchFound == null) {
                    e.merge(groupId, it);
                    matchFound = e;
                    continue;
                }
                matchFound.merge(e);
            }
            if (matchFound != null) continue;
            groups.add(new Entry<GroupId>(groupId, it));
        }
        groups.removeIf(g -> g.itineraries.isEmpty());
        ArrayList<Itinerary> result = new ArrayList<Itinerary>();
        for (Entry e : groups) {
            List<Itinerary> groupResult = e.itineraries;
            for (ItineraryListFilter filter : this.nestedFilters) {
                groupResult = filter.filter(groupResult);
            }
            result.addAll(groupResult);
        }
        return result;
    }

    private static class Entry<T extends GroupId<T>> {
        T groupId;
        List<Itinerary> itineraries = new ArrayList<Itinerary>();

        Entry(T groupId, Itinerary it) {
            this.groupId = groupId;
            this.add(it);
        }

        void merge(T groupId, Itinerary itinerary) {
            this.groupId = this.groupId.merge(groupId);
            this.itineraries.add(itinerary);
        }

        void merge(Entry<T> other) {
            this.groupId = this.groupId.merge(other.groupId);
            this.itineraries.addAll(other.itineraries);
            other.itineraries.clear();
        }

        boolean match(T groupId) {
            return this.groupId.match(groupId);
        }

        void add(Itinerary it) {
            this.itineraries.add(it);
        }
    }
}

