/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.transit.group;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;

public class RemoveOtherThanSameLegsMaxGeneralizedCost
implements RemoveItineraryFlagger {
    private final double maxCostOtherLegsFactor;

    public RemoveOtherThanSameLegsMaxGeneralizedCost(double maxCostOtherLegsFactor) {
        if (maxCostOtherLegsFactor < 1.0) {
            throw new IllegalArgumentException("maxCostOtherLegsFactor must be >= 1.0");
        }
        this.maxCostOtherLegsFactor = maxCostOtherLegsFactor;
    }

    @Override
    public String name() {
        return "other-than-same-legs-max-generalized-cost-filter";
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        if (itineraries.size() < 2) {
            return List.of();
        }
        Function<Itinerary, Set> getTripsForItinerary = itinerary -> itinerary.legs().stream().filter(Leg::isTransitLeg).map(Leg::trip).collect(Collectors.toSet());
        Set commonTrips = itineraries.stream().map(getTripsForItinerary).reduce((a, b) -> {
            a.retainAll((Collection<?>)b);
            return a;
        }).get();
        if (commonTrips.isEmpty()) {
            return List.of();
        }
        int commonLegsCost = itineraries.stream().mapToInt(itinerary -> itinerary.legs().stream().filter(Leg::isTransitLeg).filter(leg -> commonTrips.contains(leg.trip())).mapToInt(leg -> Integer.max(0, leg.generalizedCost())).sum()).min().orElseThrow();
        int minimumItineraryCost = itineraries.stream().mapToInt(it -> it.generalizedCostIncludingPenalty().toSeconds()).min().orElseThrow();
        int otherLegsCost = Integer.max(0, minimumItineraryCost - commonLegsCost);
        Cost maxLimit = Cost.costOfSeconds((double)otherLegsCost * this.maxCostOtherLegsFactor + (double)commonLegsCost);
        return itineraries.stream().filter(it -> it.generalizedCostIncludingPenalty().greaterThan(maxLimit)).toList();
    }
}

