/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.transit;

import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;

public class TransitGeneralizedCostFilter
implements RemoveItineraryFlagger {
    private final CostLinearFunction costLimitFunction;
    private final double intervalRelaxFactor;

    public TransitGeneralizedCostFilter(CostLinearFunction costLimit, double intervalRelaxFactor) {
        this.costLimitFunction = costLimit;
        this.intervalRelaxFactor = intervalRelaxFactor;
    }

    @Override
    public String name() {
        return "transit-cost-filter";
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        List<Itinerary> transitItineraries = itineraries.stream().filter(Itinerary::hasTransit).sorted(Comparator.comparing(Itinerary::generalizedCostIncludingPenalty)).toList();
        return transitItineraries.stream().filter(it -> transitItineraries.stream().anyMatch(t -> this.generalizedCostExceedsLimit((Itinerary)it, (Itinerary)t))).collect(Collectors.toList());
    }

    private boolean generalizedCostExceedsLimit(Itinerary subject, Itinerary transitItinerary) {
        return subject.generalizedCostIncludingPenalty().greaterThan(this.calculateLimit(subject, transitItinerary));
    }

    private Cost calculateLimit(Itinerary subject, Itinerary transitItinerary) {
        return this.costLimitFunction.calculate(transitItinerary.generalizedCostIncludingPenalty()).plus(this.getWaitTimeCost(transitItinerary, subject));
    }

    private Cost getWaitTimeCost(Itinerary a, Itinerary b) {
        return Cost.costOfSeconds(this.intervalRelaxFactor * (double)Math.min(Math.abs(ChronoUnit.SECONDS.between(a.startTime(), b.startTime())), Math.abs(ChronoUnit.SECONDS.between(a.endTime(), b.endTime()))));
    }
}

