/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.transit;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;

public class RemoveTransitIfWalkingIsBetter
implements RemoveItineraryFlagger {
    public static final String TAG = "transit-vs-walk-filter";

    @Override
    public String name() {
        return TAG;
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        OptionalInt minWalkCost = itineraries.stream().filter(itinerary -> itinerary.isWalkOnly()).mapToInt(Itinerary::generalizedCost).min();
        if (minWalkCost.isEmpty()) {
            return List.of();
        }
        int limit = minWalkCost.getAsInt();
        return itineraries.stream().filter(it -> !it.isStreetOnly() && it.generalizedCost() >= limit).collect(Collectors.toList());
    }

    @Override
    public boolean skipAlreadyFlaggedItineraries() {
        return false;
    }
}

