/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.transit;

import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.RemoveTransitIfStreetOnlyIsBetterResult;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;

public class RemoveTransitIfStreetOnlyIsBetter
implements RemoveItineraryFlagger {
    private final CostLinearFunction costLimitFunction;
    @Nullable
    private final Cost generalizedCostMaxLimit;
    private RemoveTransitIfStreetOnlyIsBetterResult removeTransitIfStreetOnlyIsBetterResult = null;
    public static final String TAG = "transit-vs-street-filter";

    public RemoveTransitIfStreetOnlyIsBetter(CostLinearFunction costLimitFunction, @Nullable Cost generalizedCostMaxLimit) {
        this.costLimitFunction = costLimitFunction;
        this.generalizedCostMaxLimit = generalizedCostMaxLimit;
    }

    @Override
    public String name() {
        return TAG;
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        Cost minStreetCost = null;
        if (this.generalizedCostMaxLimit != null) {
            minStreetCost = this.generalizedCostMaxLimit;
        } else {
            OptionalInt minStreetCostOption = itineraries.stream().filter(Itinerary::isStreetOnly).mapToInt(Itinerary::generalizedCost).min();
            if (minStreetCostOption.isPresent()) {
                minStreetCost = Cost.costOfSeconds(minStreetCostOption.getAsInt());
            }
        }
        if (minStreetCost == null) {
            return List.of();
        }
        this.removeTransitIfStreetOnlyIsBetterResult = new RemoveTransitIfStreetOnlyIsBetterResult(minStreetCost);
        int limit = this.costLimitFunction.calculate(minStreetCost).toSeconds();
        return itineraries.stream().filter(it -> !it.isStreetOnly() && it.generalizedCost() >= limit).toList();
    }

    @Override
    public boolean skipAlreadyFlaggedItineraries() {
        return false;
    }

    public RemoveTransitIfStreetOnlyIsBetterResult getRemoveTransitIfStreetOnlyIsBetterResult() {
        return this.removeTransitIfStreetOnlyIsBetterResult;
    }
}

