/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.transit;

import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;
import org.opentripplanner.street.search.TraverseMode;

public class RemoveItinerariesWithShortStreetLeg
implements RemoveItineraryFlagger {
    private final double minDistance;
    private final TraverseMode traverseMode;

    public RemoveItinerariesWithShortStreetLeg(double minDistance, TraverseMode traverseMode) {
        this.minDistance = minDistance;
        this.traverseMode = traverseMode;
    }

    @Override
    public String name() {
        return "remove-itineraries-with-short-street-leg";
    }

    @Override
    public Predicate<Itinerary> shouldBeFlaggedForRemoval() {
        return this::removeItineraryWithShortStreetLeg;
    }

    private boolean removeItineraryWithShortStreetLeg(Itinerary itinerary) {
        boolean hasLegsOfMode = itinerary.streetLegs().anyMatch(l -> l.getMode().equals((Object)this.traverseMode));
        if (hasLegsOfMode && itinerary.hasTransit()) {
            double distance = itinerary.streetLegs().filter(l -> l.getMode().equals((Object)this.traverseMode)).mapToDouble(Leg::distanceMeters).sum();
            return distance <= this.minDistance;
        }
        return false;
    }
}

