/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.transit;

import java.util.function.Function;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.routing.algorithm.mapping.AlertToLegMapper;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.Station;

public final class DecorateTransitAlert
implements ItineraryDecorator {
    private final AlertToLegMapper alertToLegMapper;

    public DecorateTransitAlert(TransitAlertService transitAlertService, Function<Station, MultiModalStation> getMultiModalStation) {
        this.alertToLegMapper = new AlertToLegMapper(transitAlertService, getMultiModalStation);
    }

    @Override
    public Itinerary decorate(Itinerary itinerary) {
        LegDecorator d = new LegDecorator();
        return itinerary.copyOf().transformTransitLegs(d::decorate).build();
    }

    private final class LegDecorator {
        boolean isFirstTransitLeg = true;

        private LegDecorator() {
        }

        TransitLeg decorate(TransitLeg leg) {
            if (leg.isTransitLeg()) {
                TransitLeg l = DecorateTransitAlert.this.alertToLegMapper.decorateWithAlerts(leg, this.isFirstTransitLeg);
                this.isFirstTransitLeg = false;
                return l;
            }
            return leg;
        }
    }
}

