/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system.mcmax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.SingleCriteriaComparator;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.mcmax.Group;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.mcmax.Item;

class State {
    private final List<Item> items;
    private final List<Group> groups;
    private final List<Item> result = new ArrayList<Item>();

    State(List<Itinerary> itineraries, List<SingleCriteriaComparator> comparators) {
        this.items = State.createListOfItems(itineraries);
        this.groups = State.createGroups(this.items, comparators);
    }

    List<Itinerary> getResult() {
        return this.result.stream().map(Item::item).toList();
    }

    void findAllSingleItemGroupsAndAddTheItemToTheResult() {
        Item item = State.findItemInFirstSingleItemGroup(this.groups);
        while (item != null) {
            this.addToResult(item);
            item = State.findItemInFirstSingleItemGroup(this.groups);
        }
    }

    void findTheBestItemsUntilAllGroupsAreRepresentedInTheResult() {
        while (!this.groups.isEmpty()) {
            this.addToResult(State.findBestItem(this.groups));
        }
    }

    void fillUpTheResultWithMinimumNumberOfItineraries(int minNumItineraries) {
        int end = Math.min(this.items.size(), minNumItineraries);
        int i = 0;
        while (this.result.size() < end) {
            Item it = this.items.get(i);
            if (!this.result.contains(it)) {
                this.result.add(it);
            }
            ++i;
        }
    }

    private void addToResult(Item item) {
        this.result.add(item);
        this.removeGroupsWitchContainsItem(item);
    }

    private void removeGroupsWitchContainsItem(Item item) {
        for (Group group : this.groups) {
            if (!group.contains(item)) continue;
            group.removeAllItems();
        }
        this.groups.removeIf(Group::isEmpty);
    }

    private static Item findBestItem(List<Group> groups) {
        Item candidate = groups.getFirst().first();
        for (Group group : groups) {
            for (Item item : group) {
                if (!item.betterThan(candidate)) continue;
                candidate = item;
            }
        }
        return candidate;
    }

    @Nullable
    private static Item findItemInFirstSingleItemGroup(List<Group> groups) {
        return groups.stream().filter(Group::isSingleItemGroup).findFirst().map(Group::first).orElse(null);
    }

    private static ArrayList<Item> createListOfItems(List<Itinerary> itineraries) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < itineraries.size(); ++i) {
            items.add(new Item(itineraries.get(i), i));
        }
        return items;
    }

    private static List<Group> createGroups(Collection<Item> items, List<SingleCriteriaComparator> comparators) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (SingleCriteriaComparator comparator : comparators) {
            if (comparator.strictOrder()) {
                groups.add(State.createOrderedGroup(items, comparator));
                continue;
            }
            groups.addAll(State.createUnorderedGroups(items, comparator));
        }
        return groups;
    }

    private static Group createOrderedGroup(Collection<Item> items, SingleCriteriaComparator comparator) {
        Group group = null;
        for (Item item : items) {
            if (group == null) {
                group = new Group(item);
                continue;
            }
            Item current = group.first();
            if (comparator.leftDominanceExist(item.item(), current.item())) {
                group.addNewDominantItem(item);
                continue;
            }
            if (comparator.leftDominanceExist(current.item(), item.item())) continue;
            group.add(item);
        }
        return group;
    }

    private static Collection<? extends Group> createUnorderedGroups(Collection<Item> items, SingleCriteriaComparator comparator) {
        ArrayList<Group> result = new ArrayList<Group>();
        for (Item item : items) {
            int groupCount = result.size();
            for (Group group : result) {
                Itinerary groupItem = group.first().item();
                if (comparator.leftDominanceExist(groupItem, item.item())) {
                    if (!comparator.leftDominanceExist(item.item(), groupItem)) continue;
                    --groupCount;
                    continue;
                }
                if (comparator.leftDominanceExist(item.item(), groupItem)) {
                    group.removeAllItems();
                }
                group.add(item);
            }
            if (groupCount != 0) continue;
            result.add(new Group(item));
        }
        return result;
    }
}

