/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system.mcmax;

import java.util.List;
import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.SingleCriteriaComparator;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.mcmax.State;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;

public class McMaxLimitFilter
implements RemoveItineraryFlagger {
    private final String name;
    private final int minNumItineraries;
    private final List<SingleCriteriaComparator> comparators;

    public McMaxLimitFilter(String name, int minNumItineraries, List<SingleCriteriaComparator> comparators) {
        this.name = name;
        this.minNumItineraries = minNumItineraries;
        this.comparators = comparators;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        if (itineraries.size() <= this.minNumItineraries) {
            return List.of();
        }
        State state = new State(itineraries, this.comparators);
        state.findAllSingleItemGroupsAndAddTheItemToTheResult();
        state.findTheBestItemsUntilAllGroupsAreRepresentedInTheResult();
        state.fillUpTheResultWithMinimumNumberOfItineraries(this.minNumItineraries);
        List<Itinerary> ok = state.getResult();
        return itineraries.stream().filter(Predicate.not(ok::contains)).toList();
    }
}

