/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system;

import java.util.function.ToIntFunction;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.transit.model.network.grouppriority.DefaultTransitGroupPriorityCalculator;

@FunctionalInterface
public interface SingleCriteriaComparator {
    public static final DefaultTransitGroupPriorityCalculator GROUP_PRIORITY_CALCULATOR = new DefaultTransitGroupPriorityCalculator();

    public boolean leftDominanceExist(Itinerary var1, Itinerary var2);

    default public boolean strictOrder() {
        return false;
    }

    public static SingleCriteriaComparator compareNumTransfers() {
        return SingleCriteriaComparator.compareLessThan(Itinerary::numberOfTransfers);
    }

    public static SingleCriteriaComparator compareGeneralizedCost() {
        return SingleCriteriaComparator.compareLessThan(Itinerary::generalizedCost);
    }

    public static SingleCriteriaComparator compareTransitGroupsPriority() {
        return (left, right) -> GROUP_PRIORITY_CALCULATOR.dominanceFunction().leftDominateRight(left.generalizedCost2().get().intValue(), right.generalizedCost2().get().intValue());
    }

    public static SingleCriteriaComparator compareLessThan(final ToIntFunction<Itinerary> op) {
        return new SingleCriteriaComparator(){

            @Override
            public boolean leftDominanceExist(Itinerary left, Itinerary right) {
                return op.applyAsInt(left) < op.applyAsInt(right);
            }

            @Override
            public boolean strictOrder() {
                return true;
            }
        };
    }
}

