/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.routing.algorithm.filterchain.framework.sort.SortOrderComparator;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;
import org.opentripplanner.utils.collection.ListSection;

public class PagingFilter
implements RemoveItineraryFlagger {
    public static final String TAG = "paging-filter";
    private final ListSection deduplicateSection;
    private final ItinerarySortKey itineraryPageCut;
    private final Comparator<ItinerarySortKey> sortOrderComparator;

    public PagingFilter(SortOrder sortOrder, ListSection deduplicateSection, ItinerarySortKey itineraryPageCut) {
        this.deduplicateSection = deduplicateSection;
        this.itineraryPageCut = itineraryPageCut;
        this.sortOrderComparator = SortOrderComparator.comparator(sortOrder);
    }

    @Override
    public String name() {
        return TAG;
    }

    private boolean sortsIntoDeduplicationAreaRelativeToRemovedItinerary(Itinerary itinerary) {
        return switch (this.deduplicateSection) {
            default -> throw new MatchException(null, null);
            case ListSection.HEAD -> {
                if (this.sortOrderComparator.compare(itinerary, this.itineraryPageCut) <= 0) {
                    yield true;
                }
                yield false;
            }
            case ListSection.TAIL -> this.sortOrderComparator.compare(itinerary, this.itineraryPageCut) >= 0;
        };
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        return itineraries.stream().filter(this::sortsIntoDeduplicationAreaRelativeToRemovedItinerary).collect(Collectors.toList());
    }
}

