/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;

public class OutsideSearchWindowFilter
implements RemoveItineraryFlagger {
    public static final String TAG = "outside-search-window";
    private final Instant earliestDepartureTime;
    private final Instant latestDepartureTime;

    public OutsideSearchWindowFilter(Instant earliestDepartureTime, Duration searchWindow) {
        this.earliestDepartureTime = earliestDepartureTime;
        this.latestDepartureTime = earliestDepartureTime.plus(searchWindow);
    }

    @Override
    public String name() {
        return TAG;
    }

    @Override
    public Predicate<Itinerary> shouldBeFlaggedForRemoval() {
        return it -> {
            if (it.isSearchWindowAware()) {
                Instant time = it.startTime().toInstant();
                return time.isBefore(this.earliestDepartureTime) || !time.isBefore(this.latestDepartureTime);
            }
            return false;
        };
    }

    @Override
    public boolean skipAlreadyFlaggedItineraries() {
        return false;
    }

    public static boolean taggedBy(Itinerary itinerary) {
        return itinerary.hasSystemNoticeTag(TAG);
    }
}

