/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system;

import java.time.Instant;
import java.util.List;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.utils.collection.ListSection;
import org.opentripplanner.utils.collection.ListUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class NumItinerariesFilterResult {
    private final Instant earliestRemovedDeparture;
    private final Instant latestRemovedDeparture;
    private final ItinerarySortKey pageCut;

    public NumItinerariesFilterResult(Instant earliestRemovedDeparture, Instant latestRemovedDeparture, ItinerarySortKey pageCut) {
        this.earliestRemovedDeparture = earliestRemovedDeparture;
        this.latestRemovedDeparture = latestRemovedDeparture;
        this.pageCut = pageCut;
    }

    public NumItinerariesFilterResult(List<Itinerary> keptItineraries, List<Itinerary> removedItineraries, ListSection cropSection) {
        List<Instant> removedDepartures = removedItineraries.stream().map(it -> it.startTime().toInstant()).toList();
        this.earliestRemovedDeparture = removedDepartures.stream().min(Instant::compareTo).orElse(null);
        this.latestRemovedDeparture = removedDepartures.stream().max(Instant::compareTo).orElse(null);
        this.pageCut = cropSection == ListSection.HEAD ? (ItinerarySortKey)ListUtils.first(keptItineraries) : (ItinerarySortKey)ListUtils.last(keptItineraries);
    }

    public Instant earliestRemovedDeparture() {
        return this.earliestRemovedDeparture;
    }

    public Instant latestRemovedDeparture() {
        return this.latestRemovedDeparture;
    }

    public ItinerarySortKey pageCut() {
        return this.pageCut;
    }

    public String toString() {
        return ToStringBuilder.of(NumItinerariesFilterResult.class).addDateTime("earliestRemovedDeparture", this.earliestRemovedDeparture).addDateTime("latestRemovedDeparture", this.latestRemovedDeparture).addObjOp("pageCut", (Object)this.pageCut, ItinerarySortKey::keyAsString).toString();
    }
}

