/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system;

import java.util.List;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.NumItinerariesFilterResult;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;
import org.opentripplanner.utils.collection.ListSection;

public class NumItinerariesFilter
implements RemoveItineraryFlagger {
    public static final String TAG = "number-of-itineraries-filter";
    private final int maxLimit;
    private final ListSection cropSection;
    private NumItinerariesFilterResult numItinerariesFilterResult = null;

    public NumItinerariesFilter(int maxLimit, ListSection cropSection) {
        this.maxLimit = maxLimit;
        this.cropSection = cropSection;
    }

    @Override
    public String name() {
        return TAG;
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        List<Itinerary> itinerariesToKeep;
        List<Itinerary> itinerariesToRemove;
        if (itineraries.size() <= this.maxLimit) {
            return List.of();
        }
        if (this.cropSection == ListSection.HEAD) {
            int limit = itineraries.size() - this.maxLimit;
            itinerariesToRemove = itineraries.subList(0, limit);
            itinerariesToKeep = itineraries.subList(limit, itineraries.size());
        } else {
            itinerariesToRemove = itineraries.subList(this.maxLimit, itineraries.size());
            itinerariesToKeep = itineraries.subList(0, this.maxLimit);
        }
        this.numItinerariesFilterResult = new NumItinerariesFilterResult(itinerariesToKeep, itinerariesToRemove, this.cropSection);
        return itinerariesToRemove;
    }

    public NumItinerariesFilterResult getNumItinerariesFilterResult() {
        return this.numItinerariesFilterResult;
    }
}

