/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.system;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;

public class FlexSearchWindowFilter
implements RemoveItineraryFlagger {
    public static final String TAG = "flex-outside-search-window";
    private final Instant earliestDepartureTime;
    private final Instant latestArrivalTime;
    private final SortOrder sortOrder;

    public FlexSearchWindowFilter(Instant earliestDepartureTime, Duration searchWindow, SortOrder sortOrder) {
        this.earliestDepartureTime = earliestDepartureTime;
        this.latestArrivalTime = earliestDepartureTime.plus(searchWindow);
        this.sortOrder = sortOrder;
    }

    @Override
    public String name() {
        return TAG;
    }

    @Override
    public Predicate<Itinerary> shouldBeFlaggedForRemoval() {
        return it -> {
            if (it.isDirectFlex()) {
                return switch (this.sortOrder) {
                    default -> throw new MatchException(null, null);
                    case SortOrder.STREET_AND_DEPARTURE_TIME -> {
                        Instant time = it.startTime().toInstant();
                        yield time.isBefore(this.earliestDepartureTime);
                    }
                    case SortOrder.STREET_AND_ARRIVAL_TIME -> {
                        Instant time = it.startTime().toInstant();
                        yield time.isAfter(this.latestArrivalTime);
                    }
                };
            }
            return false;
        };
    }

    @Override
    public boolean skipAlreadyFlaggedItineraries() {
        return false;
    }
}

