/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.street;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;

public class RemoveNonTransitItinerariesBasedOnGeneralizedCost
implements RemoveItineraryFlagger {
    private final CostLinearFunction costLimitFunction;

    public RemoveNonTransitItinerariesBasedOnGeneralizedCost(CostLinearFunction costLimitFunction) {
        this.costLimitFunction = costLimitFunction;
    }

    @Override
    public String name() {
        return "non-transit-cost-filter";
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        OptionalInt minGeneralizedCost = itineraries.stream().mapToInt(Itinerary::generalizedCost).min();
        if (minGeneralizedCost.isEmpty()) {
            return List.of();
        }
        int maxLimit = this.costLimitFunction.calculate(Cost.costOfSeconds(minGeneralizedCost.getAsInt())).toSeconds();
        return itineraries.stream().filter(it -> !it.hasTransit() && it.generalizedCost() > maxLimit).collect(Collectors.toList());
    }
}

