/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.filters.street;

import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;

public class RemoveBikeRentalWithMostlyWalking
implements RemoveItineraryFlagger {
    private final double bikeRentalDistanceRatio;

    public RemoveBikeRentalWithMostlyWalking(double bikeRentalDistanceRatio) {
        this.bikeRentalDistanceRatio = bikeRentalDistanceRatio;
    }

    @Override
    public String name() {
        return "bikerental-vs-walk-filter";
    }

    @Override
    public Predicate<Itinerary> shouldBeFlaggedForRemoval() {
        return itinerary -> {
            if (itinerary.hasTransit()) {
                return false;
            }
            double bikeRentalDistance = itinerary.legs().stream().filter(l -> l.rentedVehicle() != null && l.rentedVehicle() != false).mapToDouble(Leg::distanceMeters).sum();
            double totalDistance = itinerary.distanceMeters();
            return bikeRentalDistance != 0.0 && bikeRentalDistance / totalDistance <= this.bikeRentalDistanceRatio;
        };
    }
}

