/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.api;

import org.opentripplanner.utils.tostring.ToStringBuilder;

public class GroupBySimilarity {
    public final double groupByP;
    public final int maxNumOfItinerariesPerGroup;
    public final boolean nestedGroupingByAllSameStations;
    public final double maxCostOtherLegsFactor;

    private GroupBySimilarity(double groupByP, int maxNumOfItinerariesPerGroup, boolean nestedGroupingByAllSameStations, double maxCostOtherLegsFactor) {
        this.groupByP = groupByP;
        this.maxNumOfItinerariesPerGroup = maxNumOfItinerariesPerGroup;
        this.nestedGroupingByAllSameStations = nestedGroupingByAllSameStations;
        this.maxCostOtherLegsFactor = maxCostOtherLegsFactor;
    }

    public static GroupBySimilarity createWithOneItineraryPerGroup(double groupByP) {
        return new GroupBySimilarity(groupByP, 1, false, 0.0);
    }

    public static GroupBySimilarity createWithMoreThanOneItineraryPerGroup(double groupByP, int maxNumOfItinerariesPerGroup, boolean nestedGroupingByAllSameStations, double maxCostOtherLegsFactor) {
        return new GroupBySimilarity(groupByP, maxNumOfItinerariesPerGroup, nestedGroupingByAllSameStations, maxCostOtherLegsFactor);
    }

    public String toString() {
        return ToStringBuilder.of(GroupBySimilarity.class).addNum("groupByP", (Number)this.groupByP).addNum("maxNumOfItinerariesPerGroup", (Number)this.maxNumOfItinerariesPerGroup).addBoolIfTrue("nestedGroupingByAllSameStations", Boolean.valueOf(this.nestedGroupingByAllSameStations)).addNum("maxCostOtherLegsFactor", (Number)this.maxCostOtherLegsFactor).toString();
    }
}

