/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opentripplanner.ext.accessibilityscore.DecorateWithAccessibilityScore;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.paging.cursor.PageCursorInput;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilterChain;
import org.opentripplanner.routing.algorithm.filterchain.PageCursorInputAggregator;
import org.opentripplanner.routing.algorithm.filterchain.api.GroupBySimilarity;
import org.opentripplanner.routing.algorithm.filterchain.api.TransitGeneralizedCostFilterParams;
import org.opentripplanner.routing.algorithm.filterchain.filters.street.RemoveBikeRentalWithMostlyWalking;
import org.opentripplanner.routing.algorithm.filterchain.filters.street.RemoveNonTransitItinerariesBasedOnGeneralizedCost;
import org.opentripplanner.routing.algorithm.filterchain.filters.street.RemoveParkAndRideWithMostlyWalkingFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.street.RemoveWalkOnlyFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.FlexSearchWindowFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.NumItinerariesFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.OutsideSearchWindowFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.PagingFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.SingleCriteriaComparator;
import org.opentripplanner.routing.algorithm.filterchain.filters.system.mcmax.McMaxLimitFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.DecorateTransitAlert;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.KeepItinerariesWithFewestTransfers;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.RemoveItinerariesWithShortStreetLeg;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.RemoveTransitIfStreetOnlyIsBetter;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.RemoveTransitIfWalkingIsBetter;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.TransitGeneralizedCostFilter;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.group.RemoveIfFirstOrLastTripIsTheSame;
import org.opentripplanner.routing.algorithm.filterchain.filters.transit.group.RemoveOtherThanSameLegsMaxGeneralizedCost;
import org.opentripplanner.routing.algorithm.filterchain.framework.filter.DecorateFilter;
import org.opentripplanner.routing.algorithm.filterchain.framework.filter.GroupByFilter;
import org.opentripplanner.routing.algorithm.filterchain.framework.filter.MaxLimit;
import org.opentripplanner.routing.algorithm.filterchain.framework.filter.RemoveFilter;
import org.opentripplanner.routing.algorithm.filterchain.framework.filter.SortingFilter;
import org.opentripplanner.routing.algorithm.filterchain.framework.filterchain.DeleteResultHandler;
import org.opentripplanner.routing.algorithm.filterchain.framework.groupids.GroupByAllSameStations;
import org.opentripplanner.routing.algorithm.filterchain.framework.groupids.GroupByDistance;
import org.opentripplanner.routing.algorithm.filterchain.framework.groupids.GroupBySameRoutesAndStops;
import org.opentripplanner.routing.algorithm.filterchain.framework.sort.SortOrderComparator;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryListFilter;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.RemoveItineraryFlagger;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.routing.api.request.preference.ItineraryFilterDebugProfile;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.utils.collection.ListSection;

public class ItineraryListFilterChainBuilder {
    private static final int NOT_SET = -1;
    private final SortOrder sortOrder;
    private final List<GroupBySimilarity> groupBySimilarity = new ArrayList<GroupBySimilarity>();
    private ItineraryFilterDebugProfile debug = ItineraryFilterDebugProfile.OFF;
    private int maxNumberOfItineraries = -1;
    private ListSection maxNumberOfItinerariesCropSection = ListSection.TAIL;
    private CostLinearFunction removeTransitWithHigherCostThanBestOnStreetOnly;
    private boolean removeWalkAllTheWayResults;
    private boolean sameFirstOrLastTripFilter;
    private TransitGeneralizedCostFilterParams transitGeneralizedCostFilterParams;
    private double bikeRentalDistanceRatio;
    private double parkAndRideDurationRatio;
    private CostLinearFunction nonTransitGeneralizedCostLimit;
    private Consumer<PageCursorInput> pageCursorInputSubscriber = i -> {};
    private Instant earliestDepartureTime = null;
    private Duration searchWindow = null;
    private boolean accessibilityScore;
    private double wheelchairMaxSlope;
    private TransitAlertService transitAlertService;
    private Function<Station, MultiModalStation> getMultiModalStation;
    private boolean removeItinerariesWithSameRoutesAndStops;
    private double minBikeParkingDistance;
    private boolean removeTransitIfWalkingIsBetter = true;
    private ItinerarySortKey itineraryPageCut;
    private Cost generalizedCostMaxLimit = null;
    private boolean transitGroupPriorityUsed = false;
    private boolean filterDirectFlexBySearchWindow = true;
    @Nullable
    private ItineraryDecorator emissionDecorator;
    private ItineraryDecorator fareDecorator;
    private ItineraryListFilter rideHailingDecorator;
    private ItineraryDecorator stopConsolidationDecorator;

    public ItineraryListFilterChainBuilder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ItineraryListFilterChainBuilder withMaxNumberOfItineraries(int value) {
        this.maxNumberOfItineraries = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withMaxNumberOfItinerariesCropSection(ListSection section) {
        this.maxNumberOfItinerariesCropSection = section;
        return this;
    }

    public ItineraryListFilterChainBuilder addGroupBySimilarity(GroupBySimilarity groupBySimilarity) {
        this.groupBySimilarity.add(groupBySimilarity);
        return this;
    }

    public ItineraryListFilterChainBuilder withTransitGeneralizedCostLimit(TransitGeneralizedCostFilterParams transitGeneralizedCostFilterParams) {
        this.transitGeneralizedCostFilterParams = transitGeneralizedCostFilterParams;
        return this;
    }

    public ItineraryListFilterChainBuilder withNonTransitGeneralizedCostLimit(CostLinearFunction value) {
        this.nonTransitGeneralizedCostLimit = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withBikeRentalDistanceRatio(double value) {
        this.bikeRentalDistanceRatio = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withParkAndRideDurationRatio(double value) {
        this.parkAndRideDurationRatio = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveTransitWithHigherCostThanBestOnStreetOnly(CostLinearFunction value) {
        this.removeTransitWithHigherCostThanBestOnStreetOnly = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveTransitIfWalkingIsBetter(boolean value) {
        this.removeTransitIfWalkingIsBetter = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withDebugEnabled(ItineraryFilterDebugProfile value) {
        this.debug = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withSearchWindow(@Nullable Instant earliestDepartureTime, Duration searchWindow) {
        if (earliestDepartureTime != null) {
            Objects.requireNonNull(searchWindow);
        }
        this.earliestDepartureTime = earliestDepartureTime;
        this.searchWindow = searchWindow;
        return this;
    }

    public ItineraryListFilterChainBuilder withPageCursorInputSubscriber(Consumer<PageCursorInput> pageCursorInputSubscriber) {
        this.pageCursorInputSubscriber = pageCursorInputSubscriber;
        return this;
    }

    public ItineraryListFilterChainBuilder withGeneralizedCostMaxLimit(Cost generalizedCostMaxLimit) {
        this.generalizedCostMaxLimit = generalizedCostMaxLimit;
        return this;
    }

    public ItineraryListFilterChainBuilder withPagingDeduplicationFilter(ItinerarySortKey itineraryPageCut) {
        this.itineraryPageCut = itineraryPageCut;
        return this;
    }

    public ItineraryListFilterChainBuilder withTransitGroupPriority() {
        this.transitGroupPriorityUsed = true;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveWalkAllTheWayResults(boolean enable) {
        this.removeWalkAllTheWayResults = enable;
        return this;
    }

    public ItineraryListFilterChainBuilder withSameFirstOrLastTripFilter(boolean enable) {
        this.sameFirstOrLastTripFilter = enable;
        return this;
    }

    public ItineraryListFilterChainBuilder withAccessibilityScore(boolean enable, double wheelchairMaxSlope) {
        this.accessibilityScore = enable;
        this.wheelchairMaxSlope = wheelchairMaxSlope;
        return this;
    }

    public ItineraryListFilterChainBuilder withFareDecorator(ItineraryDecorator decorator) {
        this.fareDecorator = decorator;
        return this;
    }

    public ItineraryListFilterChainBuilder withEmissions(@Nullable ItineraryDecorator emissionDecorator) {
        this.emissionDecorator = emissionDecorator;
        return this;
    }

    public ItineraryListFilterChainBuilder withMinBikeParkingDistance(double distance) {
        this.minBikeParkingDistance = distance;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveTimeshiftedItinerariesWithSameRoutesAndStops(boolean remove) {
        this.removeItinerariesWithSameRoutesAndStops = remove;
        return this;
    }

    public ItineraryListFilterChainBuilder withRideHailingDecoratingFilter(ItineraryListFilter decoratorFilter) {
        this.rideHailingDecorator = decoratorFilter;
        return this;
    }

    public ItineraryListFilterChainBuilder withConsolidatedStopNamesDecorator(@Nullable ItineraryDecorator decorator) {
        this.stopConsolidationDecorator = decorator;
        return this;
    }

    public ItineraryListFilterChainBuilder withTransitAlerts(TransitAlertService transitAlertService, Function<Station, MultiModalStation> getMultiModalStation) {
        this.transitAlertService = transitAlertService;
        this.getMultiModalStation = getMultiModalStation;
        return this;
    }

    public ItineraryListFilterChain build() {
        ArrayList<ItineraryListFilter> filters = new ArrayList<ItineraryListFilter>();
        NumItinerariesFilter numItinerariesFilter = null;
        RemoveTransitIfStreetOnlyIsBetter removeTransitIfStreetOnlyIsBetter = null;
        filters.addAll(this.buildGroupByTripIdAndDistanceFilters());
        if (this.removeItinerariesWithSameRoutesAndStops) {
            filters.add(this.buildGroupBySameRoutesAndStopsFilter());
        }
        if (this.sameFirstOrLastTripFilter) {
            ItineraryListFilterChainBuilder.addSort(filters, SortOrderComparator.generalizedCostComparator());
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new RemoveIfFirstOrLastTripIsTheSame());
        }
        if (this.minBikeParkingDistance > 0.0) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new RemoveItinerariesWithShortStreetLeg(this.minBikeParkingDistance, TraverseMode.BICYCLE));
        }
        if (this.transitGeneralizedCostFilterParams != null) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new TransitGeneralizedCostFilter(this.transitGeneralizedCostFilterParams.costLimitFunction(), this.transitGeneralizedCostFilterParams.intervalRelaxFactor()));
        }
        if (this.nonTransitGeneralizedCostLimit != null) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new RemoveNonTransitItinerariesBasedOnGeneralizedCost(this.nonTransitGeneralizedCostLimit));
        }
        if (this.removeTransitWithHigherCostThanBestOnStreetOnly != null) {
            removeTransitIfStreetOnlyIsBetter = new RemoveTransitIfStreetOnlyIsBetter(this.removeTransitWithHigherCostThanBestOnStreetOnly, this.generalizedCostMaxLimit);
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, removeTransitIfStreetOnlyIsBetter);
        }
        if (this.removeTransitIfWalkingIsBetter) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new RemoveTransitIfWalkingIsBetter());
        }
        if (this.removeWalkAllTheWayResults) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new RemoveWalkOnlyFilter());
        }
        if (this.bikeRentalDistanceRatio > 0.0) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new RemoveBikeRentalWithMostlyWalking(this.bikeRentalDistanceRatio));
        }
        if (this.parkAndRideDurationRatio > 0.0) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new RemoveParkAndRideWithMostlyWalkingFilter(this.parkAndRideDurationRatio));
        }
        if (this.earliestDepartureTime != null) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new OutsideSearchWindowFilter(this.earliestDepartureTime, this.searchWindow));
        }
        if (this.earliestDepartureTime != null && this.filterDirectFlexBySearchWindow) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new FlexSearchWindowFilter(this.earliestDepartureTime, this.searchWindow, this.sortOrder));
        }
        if (this.itineraryPageCut != null) {
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, new PagingFilter(this.sortOrder, this.deduplicateSection(), this.itineraryPageCut));
        }
        if (this.maxNumberOfItineraries > 0) {
            ItineraryListFilterChainBuilder.addSort(filters, SortOrderComparator.comparator(this.sortOrder));
            numItinerariesFilter = new NumItinerariesFilter(this.maxNumberOfItineraries, this.maxNumberOfItinerariesCropSection);
            ItineraryListFilterChainBuilder.addRemoveFilter(filters, numItinerariesFilter);
        }
        ItineraryListFilterChainBuilder.addSort(filters, SortOrderComparator.comparator(this.sortOrder));
        if (this.transitAlertService != null) {
            ItineraryListFilterChainBuilder.addDecorateFilter(filters, new DecorateTransitAlert(this.transitAlertService, this.getMultiModalStation));
        }
        if (this.accessibilityScore) {
            ItineraryListFilterChainBuilder.addDecorateFilter(filters, new DecorateWithAccessibilityScore(this.wheelchairMaxSlope));
        }
        if (this.emissionDecorator != null) {
            ItineraryListFilterChainBuilder.addDecorateFilter(filters, this.emissionDecorator);
        }
        if (this.fareDecorator != null) {
            ItineraryListFilterChainBuilder.addDecorateFilter(filters, this.fareDecorator);
        }
        if (this.rideHailingDecorator != null) {
            filters.add(this.rideHailingDecorator);
        }
        if (this.stopConsolidationDecorator != null) {
            ItineraryListFilterChainBuilder.addDecorateFilter(filters, this.stopConsolidationDecorator);
        }
        DeleteResultHandler debugHandler = new DeleteResultHandler(this.debug, this.maxNumberOfItineraries);
        PageCursorInputAggregator pageCursorInputAggregator = PageCursorInputAggregator.of().withNumItinerariesFilter(numItinerariesFilter).withRemoveTransitIfStreetOnlyIsBetter(removeTransitIfStreetOnlyIsBetter).withPageCursorInputSubscriber(this.pageCursorInputSubscriber).build();
        return new ItineraryListFilterChain(filters, debugHandler, pageCursorInputAggregator);
    }

    public ItineraryListFilterChainBuilder withFilterDirectFlexBySearchWindow(boolean b) {
        this.filterDirectFlexBySearchWindow = b;
        return this;
    }

    private ItineraryListFilter buildGroupBySameRoutesAndStopsFilter() {
        return new GroupByFilter<GroupBySameRoutesAndStops>(GroupBySameRoutesAndStops::new, List.of(new SortingFilter((Comparator<ItinerarySortKey>)((Object)SortOrderComparator.comparator(this.sortOrder))), new RemoveFilter(this.createMaxLimitFilter("group-by-same-stations-and-routes", 1))));
    }

    private List<ItineraryListFilter> buildGroupByTripIdAndDistanceFilters() {
        ArrayList<String> sysTags = new ArrayList<String>();
        List<GroupBySimilarity> groupBy = this.groupBySimilarity.stream().sorted(Comparator.comparingDouble(o -> o.groupByP)).toList();
        ArrayList<ItineraryListFilter> groupByFilters = new ArrayList<ItineraryListFilter>();
        for (GroupBySimilarity group : groupBy) {
            String tag = "similar-legs-filter-%.0fp-%dx".formatted(100.0 * group.groupByP, group.maxNumOfItinerariesPerGroup);
            sysTags.add(tag);
            ArrayList<ItineraryListFilter> nested = new ArrayList<ItineraryListFilter>();
            if (group.nestedGroupingByAllSameStations) {
                String innerGroupName = tag + "-group-by-all-same-stations";
                sysTags.add(tag);
                nested.add(new GroupByFilter<GroupByAllSameStations>(GroupByAllSameStations::new, List.of(new SortingFilter((Comparator<ItinerarySortKey>)((Object)SortOrderComparator.generalizedCostComparator())), new RemoveFilter(this.createMaxLimitFilter(innerGroupName, 1)))));
            }
            if (group.maxCostOtherLegsFactor > 1.0) {
                RemoveOtherThanSameLegsMaxGeneralizedCost flagger = new RemoveOtherThanSameLegsMaxGeneralizedCost(group.maxCostOtherLegsFactor);
                sysTags.add(flagger.name());
                ItineraryListFilterChainBuilder.addRemoveFilter(nested, flagger);
            }
            ItineraryListFilterChainBuilder.addSort(nested, SortOrderComparator.generalizedCostComparator());
            ItineraryListFilterChainBuilder.addRemoveFilter(nested, this.createMaxLimitFilter(tag, group.maxNumOfItinerariesPerGroup));
            nested.add(new KeepItinerariesWithFewestTransfers(sysTags));
            groupByFilters.add(new GroupByFilter<GroupByDistance>(it -> new GroupByDistance((Itinerary)it, group.groupByP), nested));
        }
        return groupByFilters;
    }

    private ListSection deduplicateSection() {
        return this.maxNumberOfItinerariesCropSection.invert();
    }

    private static void addSort(List<ItineraryListFilter> filters, SortOrderComparator comparator) {
        filters.add(new SortingFilter((Comparator<ItinerarySortKey>)((Object)comparator)));
    }

    private static void addRemoveFilter(List<ItineraryListFilter> filters, RemoveItineraryFlagger removeFilter) {
        filters.add(new RemoveFilter(removeFilter));
    }

    private static void addDecorateFilter(List<ItineraryListFilter> filters, ItineraryDecorator decorator) {
        filters.add(new DecorateFilter(decorator));
    }

    private RemoveItineraryFlagger createMaxLimitFilter(String filterName, int maxLimit) {
        if (OTPFeature.MultiCriteriaGroupMaxFilter.isOn()) {
            ArrayList<SingleCriteriaComparator> comparators = new ArrayList<SingleCriteriaComparator>();
            comparators.add(SingleCriteriaComparator.compareGeneralizedCost());
            comparators.add(SingleCriteriaComparator.compareNumTransfers());
            if (this.transitGroupPriorityUsed) {
                comparators.add(SingleCriteriaComparator.compareTransitGroupsPriority());
            }
            return new McMaxLimitFilter(filterName, maxLimit, comparators);
        }
        return new MaxLimit(filterName, maxLimit);
    }
}

