/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.grouppriority.TransitGroupPriorityItineraryDecorator;
import org.opentripplanner.model.plan.paging.cursor.PageCursorInput;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.api.request.SearchParams;
import org.opentripplanner.routing.algorithm.RoutingResult;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilterChain;
import org.opentripplanner.routing.algorithm.mapping.PagingServiceFactory;
import org.opentripplanner.routing.algorithm.mapping.RouteRequestToFilterChainMapper;
import org.opentripplanner.routing.algorithm.mapping.RoutingResponseMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AdditionalSearchDays;
import org.opentripplanner.routing.algorithm.raptoradapter.router.FilterTransitWhenDirectModeIsEmpty;
import org.opentripplanner.routing.algorithm.raptoradapter.router.TransitRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.router.TransitRouterResult;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.DirectFlexRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.DirectStreetRouter;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteRequestBuilder;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.framework.DebugTimingAggregator;
import org.opentripplanner.service.paging.PagingService;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.network.grouppriority.TransitGroupPriorityService;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingWorker {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingWorker.class);
    private final DebugTimingAggregator debugTimingAggregator;
    private final RouteRequest request;
    private final OtpServerRequestContext serverContext;
    private final ZonedDateTime transitSearchTimeZero;
    private final AdditionalSearchDays additionalSearchDays;
    private final TransitGroupPriorityService transitGroupPriorityService;
    private SearchParams raptorSearchParamsUsed = null;
    private PageCursorInput pageCursorInput = null;

    public RoutingWorker(OtpServerRequestContext serverContext, RouteRequest orginalRequest, ZoneId zoneId) {
        this.request = orginalRequest.withPageCursor();
        this.serverContext = serverContext;
        this.debugTimingAggregator = new DebugTimingAggregator(serverContext.meterRegistry(), this.request.preferences().system().tags());
        this.transitSearchTimeZero = ServiceDateUtils.asStartOfService((Instant)this.request.dateTime(), (ZoneId)zoneId);
        this.additionalSearchDays = RoutingWorker.createAdditionalSearchDays(serverContext.raptorTuningParameters(), zoneId, this.request);
        this.transitGroupPriorityService = TransitGroupPriorityService.of(this.request.preferences().transit().relaxTransitGroupPriority(), this.request.journey().transit().priorityGroupsByAgency(), this.request.journey().transit().priorityGroupsGlobal());
    }

    public RoutingResponse route() {
        OTPRequestTimeoutException.checkForTimeout();
        this.debugTimingAggregator.finishedPrecalculating();
        RoutingResult result = RoutingResult.empty();
        if (OTPFeature.ParallelRouting.isOn()) {
            try {
                CompletableFuture<RoutingResult> r1 = CompletableFuture.supplyAsync(this::routeDirectStreet);
                CompletableFuture<RoutingResult> r2 = CompletableFuture.supplyAsync(this::routeDirectFlex);
                CompletableFuture<RoutingResult> r3 = CompletableFuture.supplyAsync(this::routeTransit);
                result.merge(r1.join(), r2.join(), r3.join());
            }
            catch (CompletionException e) {
                RoutingValidationException.unwrapAndRethrowCompletionException(e);
            }
        } else {
            result.merge(this.routeDirectStreet(), this.routeDirectFlex(), this.routeTransit());
        }
        result.transform(list -> new TransitGroupPriorityItineraryDecorator(this.transitGroupPriorityService).decorate((List<Itinerary>)list));
        this.debugTimingAggregator.finishedRouting();
        boolean removeWalkAllTheWayResultsFromDirectFlex = this.request.journey().direct().mode() == StreetMode.FLEXIBLE;
        ItineraryListFilterChain filterChain = RouteRequestToFilterChainMapper.createFilterChain(this.request, this.serverContext, this.earliestDepartureTimeUsed(), this.searchWindowUsed(), result.removeWalkAllTheWayResults() || removeWalkAllTheWayResultsFromDirectFlex, it -> {
            this.pageCursorInput = it;
        });
        result.transform(filterChain::filter);
        result.addErrors(filterChain.getRoutingErrors());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Return TripPlan with {} filtered itineraries out of {} total.", (Object)result.itineraries().stream().filter(it -> !it.isFlaggedForDeletion()).count(), (Object)result.itineraries().size());
        }
        this.debugTimingAggregator.finishedFiltering();
        PagingService pagingService = this.createPagingService(result.itineraries());
        return RoutingResponseMapper.map(this.request, result.itineraries(), result.errors(), this.debugTimingAggregator, this.serverContext.transitService(), pagingService);
    }

    private static AdditionalSearchDays createAdditionalSearchDays(RaptorTuningParameters raptorTuningParameters, ZoneId zoneId, RouteRequest request) {
        ZonedDateTime searchDateTime = ZonedDateTime.ofInstant(request.dateTime(), zoneId);
        Duration maxWindow = raptorTuningParameters.dynamicSearchWindowCoefficients().maxWindow();
        return new AdditionalSearchDays(request.arriveBy(), searchDateTime, request.searchWindow(), maxWindow, request.preferences().system().maxJourneyDuration());
    }

    @Nullable
    private Instant earliestDepartureTimeUsed() {
        if (this.raptorSearchParamsUsed == null) {
            return null;
        }
        if (!this.raptorSearchParamsUsed.isEarliestDepartureTimeSet()) {
            return null;
        }
        return this.transitSearchTimeZero.plusSeconds(this.raptorSearchParamsUsed.earliestDepartureTime()).toInstant();
    }

    @Nullable
    private Duration searchWindowUsed() {
        return this.raptorSearchParamsUsed == null ? null : Duration.ofSeconds(this.raptorSearchParamsUsed.searchWindowInSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoutingResult routeDirectStreet() {
        if (this.request.isViaSearch()) {
            return RoutingResult.empty();
        }
        FilterTransitWhenDirectModeIsEmpty emptyDirectModeHandler = new FilterTransitWhenDirectModeIsEmpty(this.request.journey().direct().mode(), this.request.pageCursor() != null);
        RouteRequestBuilder directBuilder = this.request.copyOf();
        directBuilder.withJourney(jb -> jb.withDirect(new StreetRequest(emptyDirectModeHandler.resolveDirectMode())));
        this.debugTimingAggregator.startedDirectStreetRouter();
        try {
            RoutingResult routingResult = RoutingResult.ok(DirectStreetRouter.route(this.serverContext, directBuilder.buildRequest()), emptyDirectModeHandler.removeWalkAllTheWayResults());
            return routingResult;
        }
        catch (RoutingValidationException e) {
            RoutingResult routingResult = RoutingResult.failed(e.getRoutingErrors());
            return routingResult;
        }
        finally {
            this.debugTimingAggregator.finishedDirectStreetRouter();
        }
    }

    private RoutingResult routeDirectFlex() {
        if (!OTPFeature.FlexRouting.isOn()) {
            return RoutingResult.ok(List.of());
        }
        this.debugTimingAggregator.startedDirectFlexRouter();
        try {
            RoutingResult routingResult = RoutingResult.ok(DirectFlexRouter.route(this.serverContext, this.request, this.additionalSearchDays));
            return routingResult;
        }
        catch (RoutingValidationException e) {
            RoutingResult routingResult = RoutingResult.failed(e.getRoutingErrors());
            return routingResult;
        }
        finally {
            this.debugTimingAggregator.finishedDirectFlexRouter();
        }
    }

    private RoutingResult routeTransit() {
        this.debugTimingAggregator.startedTransitRouting();
        try {
            TransitRouterResult transitResults = TransitRouter.route(this.request, this.serverContext, this.transitGroupPriorityService, this.transitSearchTimeZero, this.additionalSearchDays, this.debugTimingAggregator);
            this.raptorSearchParamsUsed = transitResults.getSearchParams();
            RoutingResult routingResult = RoutingResult.ok(transitResults.getItineraries());
            return routingResult;
        }
        catch (RoutingValidationException e) {
            RoutingResult routingResult = RoutingResult.failed(e.getRoutingErrors());
            return routingResult;
        }
        finally {
            this.debugTimingAggregator.finishedTransitRouter();
        }
    }

    private Instant searchStartTime() {
        return this.transitSearchTimeZero.toInstant();
    }

    private PagingService createPagingService(List<Itinerary> itineraries) {
        return PagingServiceFactory.createPagingService(this.searchStartTime(), this.serverContext.transitTuningParameters(), this.serverContext.raptorTuningParameters(), this.request, this.raptorSearchParamsUsed, this.pageCursorInput, itineraries);
    }
}

