/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.api.response.RoutingError;

class RoutingResult {
    private final List<Itinerary> itineraries = new ArrayList<Itinerary>();
    private final Set<RoutingError> errors = new HashSet<RoutingError>();
    private boolean removeWalkAllTheWayResults = false;

    RoutingResult(Collection<Itinerary> itineraries, Collection<RoutingError> errors, boolean removeWalkAllTheWayResults) {
        this.addItineraries(itineraries);
        this.addErrors(errors);
        this.removeWalkAllTheWayResults = removeWalkAllTheWayResults;
    }

    static RoutingResult empty() {
        return new RoutingResult(List.of(), List.of(), false);
    }

    static RoutingResult ok(List<Itinerary> itineraries, boolean removeWalkAllTheWayResults) {
        return new RoutingResult(itineraries, List.of(), removeWalkAllTheWayResults);
    }

    static RoutingResult ok(List<Itinerary> itineraries) {
        return RoutingResult.ok(itineraries, false);
    }

    static RoutingResult failed(Collection<RoutingError> errors) {
        return new RoutingResult(List.of(), errors, false);
    }

    List<Itinerary> itineraries() {
        return List.copyOf(this.itineraries);
    }

    Set<RoutingError> errors() {
        return Set.copyOf(this.errors);
    }

    public boolean removeWalkAllTheWayResults() {
        return this.removeWalkAllTheWayResults;
    }

    void merge(RoutingResult ... others) {
        for (RoutingResult it : others) {
            this.addItineraries(it.itineraries);
            this.addErrors(it.errors);
            if (!it.removeWalkAllTheWayResults) continue;
            this.removeWalkAllTheWayResults = true;
        }
    }

    void transform(Function<List<Itinerary>, List<Itinerary>> transform) {
        List<Itinerary> list = transform.apply(this.itineraries);
        if (this.itineraries != list) {
            this.itineraries.clear();
            this.itineraries.addAll(list);
        }
    }

    void addErrors(Collection<RoutingError> errors) {
        this.errors.addAll(errors);
    }

    private void addItineraries(Collection<Itinerary> itineraries) {
        this.itineraries.addAll(itineraries);
    }
}

