/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.alertpatch;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.alertpatch.AlertCause;
import org.opentripplanner.routing.alertpatch.AlertEffect;
import org.opentripplanner.routing.alertpatch.AlertSeverity;
import org.opentripplanner.routing.alertpatch.AlertUrl;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TimePeriod;
import org.opentripplanner.routing.alertpatch.TransitAlertBuilder;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.TransitBuilder;

public class TransitAlert
extends AbstractTransitEntity<TransitAlert, TransitAlertBuilder> {
    private final I18NString headerText;
    private final I18NString descriptionText;
    private final I18NString detailText;
    private final I18NString adviceText;
    private final I18NString url;
    private final List<AlertUrl> siriUrls;
    private final String type;
    private final AlertSeverity severity;
    private final AlertCause cause;
    private final AlertEffect effect;
    private final Integer priority;
    private final ZonedDateTime creationTime;
    private final Integer version;
    private final ZonedDateTime updatedTime;
    private final String siriCodespace;
    private final Set<EntitySelector> entities;
    private final List<TimePeriod> timePeriods;

    TransitAlert(TransitAlertBuilder builder) {
        super(builder.getId());
        this.headerText = builder.headerText();
        this.descriptionText = builder.descriptionText();
        this.detailText = builder.detailText();
        this.adviceText = builder.adviceText();
        this.url = builder.url();
        this.siriUrls = List.copyOf(builder.siriUrls());
        this.type = builder.type();
        this.severity = builder.severity();
        this.cause = builder.cause();
        this.effect = builder.effect();
        this.priority = builder.priority();
        this.creationTime = builder.creationTime();
        this.version = builder.version();
        this.updatedTime = builder.updatedTime();
        this.siriCodespace = builder.siriCodespace();
        this.entities = Set.copyOf(builder.entities());
        this.timePeriods = List.copyOf(builder.timePeriods());
    }

    public static TransitAlertBuilder of(FeedScopedId id) {
        return new TransitAlertBuilder(id);
    }

    public Optional<I18NString> headerText() {
        return Optional.ofNullable(this.headerText);
    }

    public Optional<I18NString> descriptionText() {
        return Optional.ofNullable(this.descriptionText);
    }

    public I18NString detailText() {
        return this.detailText;
    }

    public I18NString adviceText() {
        return this.adviceText;
    }

    public Optional<I18NString> url() {
        return Optional.ofNullable(this.url);
    }

    public List<AlertUrl> siriUrls() {
        return this.siriUrls;
    }

    public String type() {
        return this.type;
    }

    public AlertSeverity severity() {
        return this.severity;
    }

    public AlertCause cause() {
        return this.cause;
    }

    public AlertEffect effect() {
        return this.effect;
    }

    public Integer priority() {
        return this.priority;
    }

    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public ZonedDateTime updatedTime() {
        return this.updatedTime;
    }

    public String siriCodespace() {
        return this.siriCodespace;
    }

    public Set<EntitySelector> entities() {
        return this.entities;
    }

    public Collection<TimePeriod> timePeriods() {
        return this.timePeriods;
    }

    public boolean displayDuring(long startTimeSeconds, long endTimeSeconds) {
        for (TimePeriod timePeriod : this.timePeriods) {
            if (endTimeSeconds < timePeriod.startTime || timePeriod.endTime != 0L && startTimeSeconds >= timePeriod.endTime) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Instant getEffectiveStartDate() {
        return this.timePeriods.stream().map(timePeriod -> timePeriod.startTime).min(Comparator.naturalOrder()).filter(startTime -> startTime > 0L).map(Instant::ofEpochSecond).orElse(null);
    }

    @Nullable
    public Instant getEffectiveEndDate() {
        return this.timePeriods.stream().map(timePeriod -> timePeriod.endTime).max(Comparator.naturalOrder()).filter(endTime -> endTime < Long.MAX_VALUE).map(Instant::ofEpochSecond).orElse(null);
    }

    public boolean noServiceAt(Instant instant) {
        return this.effect.equals((Object)AlertEffect.NO_SERVICE) && this.getEffectiveStartDate() != null && this.getEffectiveStartDate().isBefore(instant) && (this.getEffectiveEndDate() == null || this.getEffectiveEndDate().isAfter(instant));
    }

    @Override
    public boolean sameAs(TransitAlert other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.headerText, other.headerText) && Objects.equals(this.descriptionText, other.descriptionText) && Objects.equals(this.detailText, other.detailText) && Objects.equals(this.adviceText, other.adviceText) && Objects.equals(this.url, other.url) && Objects.equals(this.siriUrls, other.siriUrls) && Objects.equals(this.type, other.type) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.cause, (Object)other.cause) && Objects.equals((Object)this.effect, (Object)other.effect) && Objects.equals(this.priority, other.priority) && Objects.equals(this.creationTime, other.creationTime) && Objects.equals(this.version, other.version) && Objects.equals(this.updatedTime, other.updatedTime) && Objects.equals(this.siriCodespace, other.siriCodespace) && Objects.equals(this.entities, other.entities) && Objects.equals(this.timePeriods, other.timePeriods);
    }

    @Override
    public TransitBuilder<TransitAlert, TransitAlertBuilder> copy() {
        return new TransitAlertBuilder(this);
    }
}

