/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty.specifier;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.wayproperty.specifier.ExactMatchSpecifier;
import org.opentripplanner.osm.wayproperty.specifier.OsmSpecifier;

public class LogicalOrSpecifier
implements OsmSpecifier {
    private final List<ExactMatchSpecifier> subSpecs;

    public LogicalOrSpecifier(ExactMatchSpecifier ... specifiers) {
        this.subSpecs = Arrays.asList(specifiers);
    }

    public LogicalOrSpecifier(String ... specs) {
        this.subSpecs = Arrays.stream(specs).map(ExactMatchSpecifier::new).toList();
    }

    @Override
    public int matchScore(OsmEntity way, TraverseDirection direction) {
        boolean oneMatchesExactly = this.subSpecs.stream().anyMatch(subspec -> switch (direction) {
            default -> throw new MatchException(null, null);
            case TraverseDirection.DIRECTIONLESS -> subspec.allTagsMatch(way);
            case TraverseDirection.FORWARD -> subspec.allForwardTagsMatch(way);
            case TraverseDirection.BACKWARD -> subspec.allBackwardTagsMatch(way);
        });
        if (oneMatchesExactly) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toDocString() {
        return this.subSpecs.stream().map(ExactMatchSpecifier::toDocString).collect(Collectors.joining("|"));
    }
}

